/*
 * Decompiled with CFR 0.152.
 */
package ch.jalu.configme.beanmapper.propertydescription;

import ch.jalu.configme.beanmapper.ConfigMeMapperException;
import ch.jalu.configme.beanmapper.propertydescription.BeanPropertyComments;
import ch.jalu.configme.beanmapper.propertydescription.BeanPropertyDescription;
import ch.jalu.typeresolver.TypeInfo;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BeanPropertyDescriptionImpl
implements BeanPropertyDescription {
    private final String name;
    private final TypeInfo typeInformation;
    private final Method getter;
    private final Method setter;
    private final BeanPropertyComments comments;

    public BeanPropertyDescriptionImpl(@NotNull String name, @NotNull TypeInfo typeInformation, @NotNull Method getter, @NotNull Method setter, @NotNull BeanPropertyComments comments) {
        this.name = name;
        this.typeInformation = typeInformation;
        this.getter = getter;
        this.setter = setter;
        this.comments = comments;
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    @Override
    @NotNull
    public TypeInfo getTypeInformation() {
        return this.typeInformation;
    }

    @Override
    @Nullable
    public Object getValue(@NotNull Object bean) {
        try {
            return this.getter.invoke(bean, new Object[0]);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new ConfigMeMapperException("Could not get property '" + this.name + "' from instance '" + String.valueOf(bean) + "'", e);
        }
    }

    @Override
    public void setValue(@NotNull Object bean, @NotNull Object value) {
        try {
            this.setter.invoke(bean, value);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new ConfigMeMapperException("Could not set property '" + this.name + "' to value '" + String.valueOf(value) + "' on instance '" + String.valueOf(bean) + "'", e);
        }
    }

    @Override
    @NotNull
    public BeanPropertyComments getComments() {
        return this.comments;
    }

    @NotNull
    public String toString() {
        return "Bean property '" + this.name + "' with getter '" + String.valueOf(this.getter) + "'";
    }
}

