/*
 * Decompiled with CFR 0.152.
 */
package ch.jalu.configme.beanmapper.context;

import ch.jalu.configme.beanmapper.ConfigMeMapperException;
import ch.jalu.configme.properties.convertresult.ConvertErrorRecorder;
import ch.jalu.typeresolver.TypeInfo;
import org.jetbrains.annotations.NotNull;

public interface MappingContext {
    @NotNull
    public MappingContext createChild(@NotNull String var1, @NotNull TypeInfo var2);

    @NotNull
    public String getBeanPath();

    @NotNull
    public TypeInfo getTargetType();

    @NotNull
    default public Class<?> getTargetTypeAsClassOrThrow() {
        Class<?> targetClass = this.getTargetType().toClass();
        if (targetClass == null) {
            throw new ConfigMeMapperException(this, "The target type cannot be converted to a class");
        }
        return targetClass;
    }

    @NotNull
    default public TypeInfo getTargetTypeArgumentOrThrow(int index) {
        TypeInfo typeArgument = this.getTargetType().getTypeArgumentInfo(index);
        if (typeArgument == null || typeArgument.toClass() == null) {
            throw new ConfigMeMapperException(this, "The type argument at index " + index + " is not well defined");
        }
        return typeArgument;
    }

    @NotNull
    public String createDescription();

    default public void registerError(@NotNull String reason) {
        this.getErrorRecorder().setHasError("For bean path '" + this.getBeanPath() + "': " + reason);
    }

    @NotNull
    public ConvertErrorRecorder getErrorRecorder();
}

