/*
 * Decompiled with CFR 0.152.
 */
package ch.jalu.configme.properties;

import ch.jalu.configme.properties.TypeBasedProperty;
import ch.jalu.configme.properties.types.ListPropertyType;
import ch.jalu.configme.properties.types.PropertyType;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class ListProperty<E>
extends TypeBasedProperty<List<E>> {
    @SafeVarargs
    public ListProperty(@NotNull String path, @NotNull PropertyType<E> entryType, E ... defaultValue) {
        this(path, entryType, Arrays.asList(defaultValue));
    }

    public ListProperty(@NotNull String path, @NotNull PropertyType<E> entryType, @NotNull List<E> defaultValue) {
        super(path, new ListPropertyType<E>(entryType), Collections.unmodifiableList(defaultValue));
    }

    protected ListProperty(@NotNull PropertyType<List<E>> type, @NotNull String path, @NotNull List<E> defaultValue) {
        super(path, type, Collections.unmodifiableList(defaultValue));
    }

    @SafeVarargs
    @NotNull
    public static <E> ListProperty<E> withListType(@NotNull String path, @NotNull PropertyType<List<E>> listType, E ... defaultValue) {
        return new ListProperty<E>(listType, path, Arrays.asList(defaultValue));
    }

    @NotNull
    public static <E> ListProperty<E> withListType(@NotNull String path, @NotNull PropertyType<List<E>> listType, @NotNull List<E> defaultValue) {
        return new ListProperty<E>(listType, path, defaultValue);
    }
}

