/*
 * Decompiled with CFR 0.152.
 */
package com.codingguru.voteban.utils;

import com.codingguru.voteban.handlers.VoteHandler;
import com.codingguru.voteban.utils.ThreadType;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

public abstract class AsyncThreadUtil
implements Runnable {
    private final ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor();
    private ThreadType threadType;
    private ScheduledFuture<?> task;

    @Override
    public void run() {
        this.runTask();
        if (this.getThreadType() != ThreadType.REPEATING) {
            this.cancel();
        }
    }

    public abstract void runTask();

    public void submitRepeatingScheduledTask(TimeUnit unit, int delay, int repeator) {
        this.task = this.executor.scheduleAtFixedRate(this, delay, repeator, unit);
        this.threadType = ThreadType.REPEATING;
    }

    public void submitRepeatingTask(TimeUnit unit, int delay) {
        this.task = this.executor.scheduleAtFixedRate(this, 0L, delay, unit);
        this.threadType = ThreadType.REPEATING;
    }

    public void submitScheduledTask(TimeUnit unit, int delay) {
        this.task = this.executor.schedule(this, (long)delay, unit);
        this.threadType = ThreadType.ONE_TIME;
    }

    public void submitTask() {
        this.executor.submit(this);
        this.threadType = ThreadType.ONE_TIME;
    }

    public ThreadType getThreadType() {
        return this.threadType;
    }

    public void cancel() {
        VoteHandler.getInstance().setActiveVote(null);
        if (this.executor != null) {
            this.executor.shutdownNow();
        }
        if (this.task != null) {
            this.task.cancel(true);
        }
    }
}

