/*
 * Decompiled with CFR 0.152.
 */
package com.codingguru.voteban.scheduler;

import com.codingguru.voteban.scheduler.VoteType;

public enum VoteResultCalculatorType {
    MIN_VOTES,
    SERVER_PERCENTAGE;


    public static VoteResultCalculatorType getVoteCalculatorType(String name) {
        VoteResultCalculatorType[] voteResultCalculatorTypeArray = VoteResultCalculatorType.values();
        int n = voteResultCalculatorTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            VoteResultCalculatorType type = voteResultCalculatorTypeArray[n2];
            if (type.name().equalsIgnoreCase(name)) {
                return type;
            }
            ++n2;
        }
        return MIN_VOTES;
    }

    public boolean isSuccessful(VoteType voteType, int votes, int playersOnline) {
        switch (this) {
            case MIN_VOTES: {
                return votes >= voteType.getMinVotes();
            }
            case SERVER_PERCENTAGE: {
                int percentage = this.calculatePercentage(votes, playersOnline);
                return percentage >= voteType.getMinVotes();
            }
        }
        return false;
    }

    public int calculatePercentage(double obtained, double total) {
        return (int)Math.round(obtained * 100.0 / total);
    }

    public String toString() {
        return this.name().toLowerCase().replaceAll("_", "-");
    }
}

