/*
 * Decompiled with CFR 0.152.
 */
package com.codingguru.voteban.scheduler;

import com.codingguru.voteban.handlers.VoteHandler;
import com.codingguru.voteban.scheduler.Schedule;
import com.codingguru.voteban.scheduler.VoteType;
import com.codingguru.voteban.utils.MessagesUtil;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class StartVoteTask
extends Schedule {
    private final UUID playerUUID;
    private final String playerName;
    private final String reason;
    private final VoteType voteType;
    private List<UUID> playersVoted;
    private int playersOnline;
    private int countdown;

    public StartVoteTask(Player target, Player sender, String reason, VoteType voteType, boolean addVote) {
        VoteHandler.getInstance().setActiveVote(this);
        this.reason = reason == null ? MessagesUtil.NO_BAN_REASON.toString() : reason;
        this.playerUUID = target.getUniqueId();
        this.playerName = target.getName();
        this.voteType = voteType;
        this.playersVoted = Lists.newArrayList();
        this.countdown = voteType.getCountdown();
        this.playersOnline = Bukkit.getOnlinePlayers().size();
        VoteHandler.getInstance().addAlreadyVotedPlayer(this.playerUUID, voteType);
        if (voteType.isStoppingChat() && (!voteType.stopChatRequiresPermission() || sender.hasPermission("VOTEBAN.*") || sender.hasPermission("VOTEBAN.STOPCHAT"))) {
            VoteHandler.getInstance().setChatDisabled(true);
        }
        if (addVote) {
            this.addVote(sender);
        }
    }

    @Override
    public void run() {
        if (this.isBroadcastingTime(this.countdown)) {
            MessagesUtil.broadcast(this.voteType.getBroadcastMessage().replaceAll("%player%", this.playerName).replaceAll("%timeleft%", String.valueOf(this.countdown)).replaceAll("%reason%", this.reason));
        }
        if (this.countdown == 0) {
            this.completeTask();
            return;
        }
        --this.countdown;
    }

    private void completeTask() {
        VoteHandler.getInstance().setActiveVote(null);
        VoteHandler.getInstance().setChatDisabled(false);
        boolean isSuccessful = this.voteType.getVoteCalculatorType().isSuccessful(this.voteType, this.getVotes(), this.playersOnline);
        if (isSuccessful) {
            this.voteType.execute(this.playerUUID, this.playerName, this.reason);
            MessagesUtil.broadcast(this.getSuccessfulVoteMessage());
        } else {
            MessagesUtil.broadcast(this.getFailedVoteMessage());
        }
        this.cancel();
    }

    private boolean isBroadcastingTime(int time) {
        return this.voteType.getAnnouncementTimes().contains(time);
    }

    private boolean isInstant() {
        return this.voteType.isInstant();
    }

    private String getSuccessfulVoteMessage() {
        return this.voteType.getSuccessfulVoteMessage().replaceAll("%player%", this.playerName).replaceAll("%timeleft%", String.valueOf(this.countdown)).replaceAll("%reason%", this.reason).replaceAll("%votes%", String.valueOf(this.getVotes()));
    }

    private String getFailedVoteMessage() {
        return this.voteType.getFailedVoteMessage().replaceAll("%player%", this.playerName).replaceAll("%timeleft%", String.valueOf(this.countdown)).replaceAll("%reason%", this.reason).replaceAll("%votes%", String.valueOf(this.getVotes()));
    }

    private int getMinimumRequiredVotes() {
        return this.voteType.getMinVotes();
    }

    private int getVotes() {
        return this.playersVoted.size();
    }

    public boolean canVote(Player sender) {
        return !this.playersVoted.contains(sender.getUniqueId());
    }

    public void addVote(Player sender) {
        this.playersVoted.add(sender.getUniqueId());
        MessagesUtil.sendMessage((CommandSender)sender, MessagesUtil.SUCCESSFUL_VOTE.toString().replaceAll("%player%", this.playerName));
        if (this.voteType.isAnnouncingVotes()) {
            MessagesUtil.broadcast(MessagesUtil.VOTE_ADDED.toString().replaceAll("%votedplayer%", sender.getName()).replaceAll("%target%", this.playerName).replaceAll("%type%", this.voteType.toString()));
        }
        if (this.getVotes() >= this.getMinimumRequiredVotes() && this.isInstant()) {
            this.completeTask();
        }
    }
}

