/*
 * Decompiled with CFR 0.152.
 */
package com.codingguru.voteban.scheduler;

import com.codingguru.voteban.VoteBan;
import com.codingguru.voteban.utils.ServerTypeUtil;
import io.papermc.paper.threadedregions.scheduler.ScheduledTask;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;

public abstract class Schedule
implements Runnable {
    private final boolean USING_FOLIA = VoteBan.getInstance().getServerType() == ServerTypeUtil.FOLIA;
    private BukkitTask bukkitTask;
    private ScheduledTask foliaTask;

    public void runTask() {
        if (this.USING_FOLIA) {
            Bukkit.getGlobalRegionScheduler().execute((Plugin)VoteBan.getInstance(), (Runnable)this);
        } else {
            this.bukkitTask = Bukkit.getScheduler().runTask((Plugin)VoteBan.getInstance(), (Runnable)this);
        }
    }

    public void runTaskLater(long delay) {
        if (this.USING_FOLIA) {
            this.foliaTask = Bukkit.getGlobalRegionScheduler().runDelayed((Plugin)VoteBan.getInstance(), t -> this.run(), delay);
        } else {
            this.bukkitTask = Bukkit.getScheduler().runTaskLater((Plugin)VoteBan.getInstance(), (Runnable)this, delay);
        }
    }

    public void runTaskAtFixedRate(long delay) {
        if (this.USING_FOLIA) {
            this.foliaTask = Bukkit.getGlobalRegionScheduler().runAtFixedRate((Plugin)VoteBan.getInstance(), t -> this.run(), delay, delay);
        } else {
            this.bukkitTask = Bukkit.getScheduler().runTaskTimer((Plugin)VoteBan.getInstance(), (Runnable)this, delay, delay);
        }
    }

    public void cancel() {
        if (this.USING_FOLIA) {
            if (this.foliaTask != null) {
                this.foliaTask.cancel();
                this.foliaTask = null;
            }
        } else if (this.bukkitTask != null) {
            this.bukkitTask.cancel();
            this.bukkitTask = null;
        }
    }
}

