/*
 * Decompiled with CFR 0.152.
 */
package com.codingguru.voteban.handlers;

import com.codingguru.voteban.VoteBan;
import com.codingguru.voteban.obj.VotedDetails;
import com.codingguru.voteban.scheduler.StartVoteTask;
import com.codingguru.voteban.scheduler.VoteType;
import com.google.common.collect.Maps;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;

public class VoteHandler {
    private static final VoteHandler INSTANCE = new VoteHandler();
    private boolean isChatDisabled = false;
    private Map<UUID, VotedDetails> alreadyVotedPlayers = Maps.newHashMap();
    private StartVoteTask activeVote;

    public void setActiveVote(StartVoteTask activeVote) {
        this.activeVote = activeVote;
    }

    public StartVoteTask getActiveVote() {
        return this.activeVote;
    }

    public boolean hasActiveVote() {
        return this.activeVote != null;
    }

    public void filterAlreadyVotedPlayers() {
        Iterator<UUID> iter = this.alreadyVotedPlayers.keySet().iterator();
        while (iter.hasNext()) {
            UUID uuid = iter.next();
            VotedDetails details = this.alreadyVotedPlayers.get(uuid);
            if (System.currentTimeMillis() < details.getEndTime()) continue;
            iter.remove();
        }
    }

    public boolean isVoteAllowed(VoteType voteType, UUID uuid) {
        if (!VoteBan.getInstance().getConfig().getBoolean("already-voted.enabled")) {
            return true;
        }
        if (this.alreadyVotedPlayers.containsKey(uuid)) {
            VotedDetails votedDetails = this.alreadyVotedPlayers.get(uuid);
            if (System.currentTimeMillis() >= votedDetails.getEndTime()) {
                this.alreadyVotedPlayers.remove(uuid);
                return true;
            }
            if (!VoteBan.getInstance().getConfig().getBoolean("already-voted.allow-different-votes")) {
                return false;
            }
            if (voteType == votedDetails.getVoteType()) {
                return false;
            }
        }
        return true;
    }

    public void removeAlreadyVotedPlayer(UUID uuid) {
        this.alreadyVotedPlayers.remove(uuid);
    }

    public void addAlreadyVotedPlayer(UUID uuid, VoteType type) {
        if (!VoteBan.getInstance().getConfig().getBoolean("already-voted.enabled")) {
            return;
        }
        long timeAdded = VoteBan.getInstance().getConfig().getInt("already-voted.length") * 1000;
        long endTime = System.currentTimeMillis() + timeAdded;
        VotedDetails votedDetails = new VotedDetails(endTime, type);
        this.alreadyVotedPlayers.put(uuid, votedDetails);
    }

    public void setChatDisabled(boolean isChatDisabled) {
        this.isChatDisabled = isChatDisabled;
    }

    public boolean isChatDisabled() {
        return this.isChatDisabled;
    }

    public static VoteHandler getInstance() {
        return INSTANCE;
    }
}

