/*
 * Decompiled with CFR 0.152.
 */
package com.codingguru.voteban;

import com.codingguru.voteban.commands.AddVoteCmd;
import com.codingguru.voteban.commands.VoteBanCmd;
import com.codingguru.voteban.commands.VoteKickCmd;
import com.codingguru.voteban.commands.VoteMuteCmd;
import com.codingguru.voteban.listeners.AsyncPlayerChat;
import com.codingguru.voteban.managers.SettingsManager;
import com.codingguru.voteban.scheduler.FilterTask;
import com.codingguru.voteban.utils.ConsoleUtil;
import com.codingguru.voteban.utils.ServerTypeUtil;
import net.kyori.adventure.platform.bukkit.BukkitAudiences;
import org.bukkit.command.CommandExecutor;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class VoteBan
extends JavaPlugin {
    private static VoteBan INSTANCE;
    private SettingsManager settingsManager;
    private ServerTypeUtil serverType;
    private BukkitAudiences adventureAPI;

    public void onEnable() {
        INSTANCE = this;
        this.setupServerType();
        ConsoleUtil.sendPluginSetup();
        this.saveDefaultConfig();
        this.settingsManager = new SettingsManager();
        this.settingsManager.setup((Plugin)this);
        if (this.getConfig().getBoolean("use-mini-message")) {
            this.adventureAPI = BukkitAudiences.create((Plugin)this);
        }
        this.getCommand("voteban").setExecutor((CommandExecutor)new VoteBanCmd());
        this.getCommand("votekick").setExecutor((CommandExecutor)new VoteKickCmd());
        this.getCommand("votemute").setExecutor((CommandExecutor)new VoteMuteCmd());
        this.getCommand("addvote").setExecutor((CommandExecutor)new AddVoteCmd());
        this.getServer().getPluginManager().registerEvents((Listener)new AsyncPlayerChat(), (Plugin)this);
        FilterTask filterTask = new FilterTask();
        filterTask.runTaskAtFixedRate(6000L);
    }

    private void setupServerType() {
        try {
            Class.forName("io.papermc.paper.threadedregions.RegionizedServer");
            this.serverType = ServerTypeUtil.FOLIA;
            return;
        }
        catch (ClassNotFoundException classNotFoundException) {
            try {
                Class.forName("io.papermc.paper.ServerBuildInfo");
                this.serverType = ServerTypeUtil.PAPER;
                return;
            }
            catch (ClassNotFoundException classNotFoundException2) {
                this.serverType = ServerTypeUtil.SPIGOT;
                return;
            }
        }
    }

    public ServerTypeUtil getServerType() {
        return this.serverType;
    }

    public BukkitAudiences getAdventure() {
        return this.adventureAPI;
    }

    public SettingsManager getSettingsManager() {
        return this.settingsManager;
    }

    public static VoteBan getInstance() {
        return INSTANCE;
    }
}

