/*
 * Decompiled with CFR 0.152.
 */
package com.codingguru.trailpaths.utils;

import com.codingguru.trailpaths.TrailPaths;
import com.codingguru.trailpaths.utils.ColorUtil;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.MiniMessage;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;

public enum MessagesUtil {
    HELP_TITLE("&c&lTrailPaths &r&7- Help Menu", false),
    HELP_COMMAND("&c%command% &7- %description%", false),
    TOGGLE_PATH_ON("&eYou have toggled your trail paths: &aON", true),
    TOGGLE_PATH_OFF("&eYou have toggled your trail paths: &cOFF", true),
    RELOAD("&aYou have successfully reloaded all configuration files.", true),
    NO_PERMISSION("&cYou do not have permission to execute this command.", true),
    IN_GAME_ONLY("&cThis command can only be executed in game.", true),
    INCORRECT_USAGE("&cCorrect Usage: %command%", true);

    private String defaultValue;
    private boolean usePrefix;

    private MessagesUtil(String defaultValue, boolean usePrefix) {
        this.defaultValue = defaultValue;
        this.usePrefix = usePrefix;
    }

    public String getDefault() {
        return this.defaultValue;
    }

    public String getPath() {
        return this.name();
    }

    public boolean usePrefix() {
        return this.usePrefix;
    }

    public String toString() {
        String message = TrailPaths.getInstance().getSettingsManager().getLang().isSet(this.getPath()) ? TrailPaths.getInstance().getSettingsManager().getLang().getString(this.getPath()) : this.defaultValue;
        if (!TrailPaths.getInstance().getConfig().getBoolean("use-mini-message")) {
            message = ColorUtil.replace(message);
        }
        return message;
    }

    public static void broadcast(String message) {
        Bukkit.getOnlinePlayers().stream().forEach(player -> MessagesUtil.sendMessage((CommandSender)player, message));
    }

    public static void sendMiniMessage(CommandSender sender, String replacedString) {
        Audience audience = TrailPaths.getInstance().getAdventure().sender(sender);
        MiniMessage mm = MiniMessage.miniMessage();
        Object replacedMessage = mm.deserialize(replacedString);
        audience.sendMessage((Component)replacedMessage);
    }

    public static void sendMessage(CommandSender sender, String replacedString) {
        String[] message;
        if (replacedString.equalsIgnoreCase("")) {
            return;
        }
        if (TrailPaths.getInstance().getConfig().getBoolean("use-mini-message")) {
            MessagesUtil.sendMiniMessage(sender, replacedString);
            return;
        }
        String[] stringArray = message = replacedString.split("\\\\n");
        int n = message.length;
        int n2 = 0;
        while (n2 < n) {
            String msg = stringArray[n2];
            sender.sendMessage(msg.replace("\\n", ""));
            ++n2;
        }
    }
}

