/*
 * Decompiled with CFR 0.152.
 */
package com.codingguru.trailpaths.util.profiles.objects;

import com.codingguru.trailpaths.util.profiles.PlayerProfiles;
import com.codingguru.trailpaths.util.profiles.PlayerUUIDs;
import com.codingguru.trailpaths.util.profiles.exceptions.InvalidProfileException;
import com.codingguru.trailpaths.util.profiles.exceptions.ProfileException;
import com.codingguru.trailpaths.util.profiles.exceptions.UnknownPlayerException;
import com.codingguru.trailpaths.util.profiles.gameprofile.MojangGameProfile;
import com.codingguru.trailpaths.util.profiles.gameprofile.XGameProfile;
import com.codingguru.trailpaths.util.profiles.mojang.MojangAPI;
import com.codingguru.trailpaths.util.profiles.mojang.PlayerProfileFetcherThread;
import com.codingguru.trailpaths.util.profiles.mojang.ProfileRequestConfiguration;
import com.codingguru.trailpaths.util.profiles.objects.ProfileContainer;
import com.codingguru.trailpaths.util.profiles.objects.ProfileInputType;
import com.codingguru.trailpaths.util.profiles.objects.cache.TimedCacheableProfileable;
import com.codingguru.trailpaths.util.profiles.objects.transformer.ProfileTransformer;
import com.codingguru.trailpaths.util.profiles.objects.transformer.TransformableProfile;
import com.codingguru.trailpaths.util.reflection.XReflection;
import com.codingguru.trailpaths.util.reflection.minecraft.MinecraftPackage;
import com.google.common.base.Function;
import com.google.common.base.Strings;
import com.mojang.authlib.GameProfile;
import java.lang.invoke.MethodHandle;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.bukkit.OfflinePlayer;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.Skull;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.bukkit.profile.PlayerProfile;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public interface Profileable {
    @Nullable
    @ApiStatus.Internal
    public @Unmodifiable MojangGameProfile getProfile();

    @Contract(pure=true)
    public boolean isReady();

    @Nullable
    @Contract(value="-> new")
    default public ProfileException test() {
        try {
            this.getProfile();
            return null;
        }
        catch (ProfileException ex) {
            return ex;
        }
    }

    @Nullable
    @ApiStatus.Internal
    @Contract(value="-> new")
    default public MojangGameProfile getDisposableProfile() {
        MojangGameProfile profile = this.getProfile();
        return profile == null ? null : profile.copy();
    }

    @NotNull
    @Contract(value="_ -> new", pure=true)
    default public Profileable transform(ProfileTransformer ... transformers) {
        return new TransformableProfile(this, Arrays.asList(transformers));
    }

    @Nullable
    default public String getProfileValue() {
        return PlayerProfiles.getOriginalValue(this.getProfile());
    }

    @NotNull
    @Contract(value="-> new")
    @ApiStatus.Experimental
    default public CompletableFuture<Profileable> prepare() {
        if (this.isReady()) {
            return CompletableFuture.completedFuture(this);
        }
        return XReflection.stacktrace(CompletableFuture.supplyAsync(this::getProfile, PlayerProfileFetcherThread.EXECUTOR).thenApply(x -> this));
    }

    @NotNull
    @Contract(value="_ -> new")
    @ApiStatus.Experimental
    public static <C extends Collection<Profileable>> CompletableFuture<C> prepare(@NotNull C profileables) {
        return Profileable.prepare(profileables, null, null);
    }

    @NotNull
    @Contract(value="_, _, _ -> new")
    @ApiStatus.Experimental
    public static <C extends Collection<Profileable>> CompletableFuture<C> prepare(@NotNull C profileables, @Nullable ProfileRequestConfiguration config, @Nullable Function<Throwable, Boolean> errorHandler) {
        Objects.requireNonNull(profileables, "Profile list is null");
        if (profileables.isEmpty()) {
            return CompletableFuture.completedFuture(profileables);
        }
        CompletableFuture initial = CompletableFuture.completedFuture(new HashMap());
        ArrayList<String> usernameRequests = new ArrayList<String>();
        if (!PlayerUUIDs.isOnlineMode()) {
            for (Profileable profileable : profileables) {
                String username = null;
                if (profileable instanceof UsernameProfileable) {
                    username = ((UsernameProfileable)profileable).username;
                } else if (profileable instanceof PlayerProfileable) {
                    username = ((PlayerProfileable)profileable).username;
                } else if (profileable instanceof StringProfileable && ((StringProfileable)profileable).determineType().type == ProfileInputType.USERNAME) {
                    username = ((StringProfileable)profileable).string;
                }
                if (username == null) continue;
                usernameRequests.add(username);
            }
            if (usernameRequests.size() > 1) {
                initial = CompletableFuture.supplyAsync(() -> MojangAPI.usernamesToUUIDs(usernameRequests, config), PlayerProfileFetcherThread.EXECUTOR);
            }
        }
        return XReflection.stacktrace(((CompletableFuture)initial.thenCompose(a -> {
            ArrayList<CompletableFuture<MojangGameProfile>> profileTasks = new ArrayList<CompletableFuture<MojangGameProfile>>(profileables.size());
            for (Profileable profileable : profileables) {
                CompletionStage<MojangGameProfile> profileTask;
                if (profileable.isReady()) {
                    profileTask = CompletableFuture.completedFuture(profileable.getProfile());
                } else {
                    profileTask = CompletableFuture.supplyAsync(profileable::getProfile, PlayerProfileFetcherThread.EXECUTOR);
                    if (errorHandler != null) {
                        profileTask = XReflection.stacktrace(profileTask).exceptionally(ex -> {
                            boolean rethrow = (Boolean)errorHandler.apply(ex);
                            if (rethrow) {
                                throw XReflection.throwCheckedException(ex);
                            }
                            return null;
                        });
                    }
                }
                profileTasks.add((CompletableFuture<MojangGameProfile>)profileTask);
            }
            return CompletableFuture.allOf(profileTasks.toArray(new CompletableFuture[0]));
        })).thenApply(a -> profileables));
    }

    @NotNull
    @Contract(pure=true)
    public static Profileable username(@NotNull String username) {
        return new UsernameProfileable(username);
    }

    @NotNull
    @Contract(pure=true)
    public static Profileable of(@NotNull UUID uuid) {
        return new UUIDProfileable(uuid);
    }

    @NotNull
    @Contract(pure=true)
    public static Profileable of(@NotNull GameProfile profile, boolean fetchTexturesIfNeeded) {
        return Profileable.of(XGameProfile.of(profile), fetchTexturesIfNeeded);
    }

    @NotNull
    @Contract(pure=true)
    public static Profileable of(@NotNull MojangGameProfile profile, boolean fetchTexturesIfNeeded) {
        return fetchTexturesIfNeeded ? new RawGameProfileProfileable(profile) : new DynamicGameProfileProfileable(profile);
    }

    @NotNull
    @Contract(pure=true)
    public static Profileable of(@NotNull OfflinePlayer offlinePlayer) {
        return new PlayerProfileable(offlinePlayer);
    }

    @NotNull
    @Contract(pure=true)
    public static Profileable of(@NotNull BlockState blockState) {
        return new ProfileContainer.BlockStateProfileContainer((Skull)blockState);
    }

    @NotNull
    @Contract(pure=true)
    public static Profileable of(@NotNull Block block) {
        return new ProfileContainer.BlockProfileContainer(block);
    }

    @NotNull
    @Contract(pure=true)
    public static Profileable of(@NotNull ItemStack item) {
        return new ProfileContainer.ItemStackProfileContainer(item);
    }

    @NotNull
    @Contract(pure=true)
    public static Profileable of(@NotNull ItemMeta meta) {
        return new ProfileContainer.ItemMetaProfileContainer((SkullMeta)meta);
    }

    @NotNull
    @Contract(pure=true)
    public static Profileable detect(@NotNull String input) {
        return new StringProfileable(input, null);
    }

    @NotNull
    @Contract(pure=true)
    public static Profileable of(@NotNull ProfileInputType type, @NotNull String input) {
        Objects.requireNonNull(type, () -> "Cannot profile from a null input type: " + input);
        Objects.requireNonNull(input, () -> "Cannot profile from a null input: " + (Object)((Object)type));
        return new StringProfileable(input, type);
    }

    @ApiStatus.Internal
    public static final class UsernameProfileable
    extends TimedCacheableProfileable {
        private final String username;
        private Boolean valid;

        public UsernameProfileable(String username) {
            this.username = Objects.requireNonNull(username);
        }

        @Override
        public String getProfileValue() {
            return this.username;
        }

        @Override
        protected MojangGameProfile cacheProfile() {
            if (this.valid == null) {
                this.valid = ProfileInputType.USERNAME.pattern.matcher(this.username).matches();
            }
            if (!this.valid.booleanValue()) {
                throw new InvalidProfileException(this.username, "Invalid username: '" + this.username + '\'');
            }
            Optional<GameProfile> profileOpt = MojangAPI.getMojangCachedProfileFromUsername(this.username);
            if (!profileOpt.isPresent()) {
                throw new UnknownPlayerException((Object)this.username, "Cannot find player named '" + this.username + '\'');
            }
            MojangGameProfile profile = XGameProfile.of(profileOpt.get());
            if (PlayerProfiles.hasTextures(profile)) {
                return profile;
            }
            return XGameProfile.of(MojangAPI.getOrFetchProfile(profile));
        }
    }

    @ApiStatus.Internal
    public static final class PlayerProfileable
    extends TimedCacheableProfileable {
        @Nullable
        private final String username;
        @NotNull
        private final UUID id;

        public PlayerProfileable(OfflinePlayer player) {
            Objects.requireNonNull(player);
            this.username = player.getName();
            this.id = player.getUniqueId();
        }

        @Override
        public String getProfileValue() {
            return Strings.isNullOrEmpty((String)this.username) ? this.id.toString() : this.username;
        }

        @Override
        protected MojangGameProfile cacheProfile() {
            if (Strings.isNullOrEmpty((String)this.username)) {
                return new UUIDProfileable(this.id).getProfile();
            }
            return new UsernameProfileable(this.username).getProfile();
        }
    }

    @ApiStatus.Internal
    public static final class StringProfileable
    extends TimedCacheableProfileable {
        private final String string;
        @Nullable
        private ProfileInputType type;

        public StringProfileable(String string, @Nullable ProfileInputType type) {
            this.string = Objects.requireNonNull(string, "Input string is null");
            this.type = type;
        }

        @Override
        public String getProfileValue() {
            return this.string;
        }

        @Override
        protected Duration expiresAfter() {
            this.determineType();
            if (this.type == null) {
                return Duration.ZERO;
            }
            switch (this.type) {
                case USERNAME: 
                case UUID: {
                    return super.expiresAfter();
                }
            }
            return Duration.ZERO;
        }

        private StringProfileable determineType() {
            if (this.type == null) {
                this.type = ProfileInputType.typeOf(this.string);
            }
            return this;
        }

        @Override
        protected MojangGameProfile cacheProfile() {
            this.determineType();
            if (this.type == null) {
                throw new InvalidProfileException(this.string, "Unknown skull string value: " + this.string);
            }
            return this.type.getProfile(this.string);
        }
    }

    @ApiStatus.Internal
    public static final class UUIDProfileable
    extends TimedCacheableProfileable {
        private final UUID id;

        public UUIDProfileable(UUID id) {
            this.id = Objects.requireNonNull(id, "UUID cannot be null");
        }

        @Override
        public String getProfileValue() {
            return this.id.toString();
        }

        @Override
        protected MojangGameProfile cacheProfile() {
            MojangGameProfile profile = XGameProfile.of(MojangAPI.getCachedProfileByUUID(this.id));
            if (PlayerProfiles.hasTextures(profile)) {
                return profile;
            }
            return XGameProfile.of(MojangAPI.getOrFetchProfile(profile));
        }
    }

    @ApiStatus.Internal
    public static final class RawGameProfileProfileable
    implements Profileable {
        private final MojangGameProfile profile;

        public RawGameProfileProfileable(MojangGameProfile profile) {
            this.profile = Objects.requireNonNull(profile);
        }

        @Override
        public boolean isReady() {
            return true;
        }

        @Override
        @NotNull
        public @Unmodifiable MojangGameProfile getProfile() {
            return this.profile;
        }
    }

    @ApiStatus.Internal
    public static final class DynamicGameProfileProfileable
    extends TimedCacheableProfileable {
        private final MojangGameProfile profile;

        public DynamicGameProfileProfileable(MojangGameProfile profile) {
            this.profile = Objects.requireNonNull(profile);
        }

        @Override
        protected MojangGameProfile cacheProfile() {
            if (PlayerProfiles.hasTextures(this.profile)) {
                return this.profile;
            }
            return (PlayerUUIDs.isOnlineMode() ? new UUIDProfileable(this.profile.id()) : new UsernameProfileable(this.profile.name())).getProfile();
        }
    }

    @ApiStatus.Internal
    public static final class PlayerProfileProfileable
    extends TimedCacheableProfileable {
        @NotNull
        private final PlayerProfile profile;
        @Nullable
        private PlayerProfile updated;
        private static final MethodHandle CraftPlayerProfile_buildGameProfile = (MethodHandle)XReflection.ofMinecraft().inPackage(MinecraftPackage.CB, "profile").named("CraftPlayerProfile").method("public com.mojang.authlib.GameProfile buildGameProfile()").reflectOrNull();

        public PlayerProfileProfileable(PlayerProfile profile) {
            this.profile = Objects.requireNonNull(profile);
        }

        @Override
        protected MojangGameProfile cacheProfile() {
            this.updated = (PlayerProfile)this.profile.update().join();
            if (CraftPlayerProfile_buildGameProfile == null) {
                MojangGameProfile gameProfile = XGameProfile.create(this.updated.getUniqueId(), this.updated.getName());
                String skinURL = this.updated.getTextures().getSkin().toString();
                String base64 = PlayerProfiles.encodeBase64("{\"textures\":{\"SKIN\":{\"url\":\"" + skinURL + "\"}}}");
                PlayerProfiles.setTexturesProperty(gameProfile, base64);
                return gameProfile;
            }
            try {
                return XGameProfile.of(CraftPlayerProfile_buildGameProfile.invoke(this.updated));
            }
            catch (Throwable e) {
                throw new RuntimeException(e);
            }
        }
    }
}

