/*
 * Decompiled with CFR 0.152.
 */
package com.codingguru.trailpaths.util.paper;

import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.MiniMessage;
import org.bukkit.inventory.meta.ItemMeta;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public final class AdventureAPIFactory {
    private static final MiniMessage DEFAULT_MINI_MESSAGE = MiniMessage.miniMessage();

    public static void setDisplayNameFromString(ItemMeta meta, String miniMessageText) {
        Object displayName = DEFAULT_MINI_MESSAGE.deserialize(miniMessageText);
        meta.displayName(displayName);
    }

    public static void setLoreFromString(ItemMeta meta, List<String> miniMessageLoreLines) {
        List lore = miniMessageLoreLines.stream().map(line -> line.isEmpty() ? Component.empty() : DEFAULT_MINI_MESSAGE.deserialize(line)).collect(Collectors.toList());
        meta.lore(lore);
    }

    public static void setDisplayName(ItemMeta meta, Component displayname) {
        meta.displayName(displayname);
    }

    public static void setLore(ItemMeta meta, List<? extends Component> lore) {
        meta.lore(lore);
    }

    public static String displayName(ItemMeta meta, Function<List<? extends Component>, List<String>> miniMessageHandler) {
        return miniMessageHandler.apply(Collections.singletonList(meta.displayName())).get(0);
    }

    public static List<String> lore(ItemMeta meta, Function<List<? extends Component>, List<String>> miniMessageHandler) {
        return miniMessageHandler.apply(meta.lore());
    }
}

