/*
 * Decompiled with CFR 0.152.
 */
package com.codingguru.trailpaths.utils;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.Random;

public class WeightedRandomUtil<T> {
    private final List<Entry> entries = Lists.newArrayList();
    private final Random rand = new Random();
    private double accumulatedWeight;

    public void addEntry(T item, double weight) {
        if (weight == 0.0) {
            weight = 100.0;
        }
        this.accumulatedWeight += weight;
        Entry e = new Entry();
        e.item = item;
        e.accumulatedWeight = this.accumulatedWeight;
        this.entries.add(e);
    }

    public List<Entry> getEntries() {
        return this.entries;
    }

    public T getRandom() {
        double r = this.rand.nextDouble() * this.accumulatedWeight;
        for (Entry entry : this.entries) {
            if (!(entry.accumulatedWeight >= r)) continue;
            return entry.item;
        }
        return null;
    }

    public int size() {
        return this.entries.size();
    }

    private class Entry {
        double accumulatedWeight;
        T item;

        private Entry() {
        }
    }
}

