/*
 * Decompiled with CFR 0.152.
 */
package com.codingguru.trailpaths.handlers;

import com.codingguru.trailpaths.TrailPaths;
import com.codingguru.trailpaths.utils.ConsoleUtil;
import com.codingguru.trailpaths.utils.WeightedRandomUtil;
import com.cryptomorin.xseries.XMaterial;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;

public class PathHandler {
    private static final PathHandler INSTANCE = new PathHandler();
    private Map<Material, WeightedRandomUtil<Material>> pathMaterials = Maps.newHashMap();
    private Set<UUID> disabledPaths = Sets.newHashSet();

    private PathHandler() {
        this.resetMaterials();
    }

    public void resetMaterials() {
        this.pathMaterials.clear();
        for (String materialName : TrailPaths.getInstance().getConfig().getConfigurationSection("paths").getKeys(false)) {
            Optional<XMaterial> materialToChange = XMaterial.matchXMaterial(materialName);
            if (!materialToChange.isPresent()) {
                ConsoleUtil.warning("[TrailPaths] Could not add material: " + materialName + " as it does not exist.");
                continue;
            }
            WeightedRandomUtil<Material> materialsToChangeTo = new WeightedRandomUtil<Material>();
            ConfigurationSection section = TrailPaths.getInstance().getConfig().getConfigurationSection("paths." + materialName);
            if (section == null) {
                ConsoleUtil.warning("[TrailPaths] Using old config format. Please update to new format.");
                continue;
            }
            for (String changeToName : section.getKeys(false)) {
                Optional<XMaterial> changeMaterialToType = XMaterial.matchXMaterial(changeToName);
                if (!changeMaterialToType.isPresent()) {
                    ConsoleUtil.warning("[TrailPaths] Could not add material: " + changeToName + " as it does not exist.");
                    continue;
                }
                int percentage = TrailPaths.getInstance().getConfig().getInt("paths." + materialName + "." + changeToName);
                materialsToChangeTo.addEntry(changeMaterialToType.get().parseMaterial(), percentage);
            }
            this.pathMaterials.put(materialToChange.get().parseMaterial(), materialsToChangeTo);
        }
    }

    public boolean isPathDisabled(UUID uuid) {
        return this.disabledPaths.contains(uuid);
    }

    public void enablePath(UUID uuid) {
        this.disabledPaths.remove(uuid);
    }

    public void disablePath(UUID uuid) {
        this.disabledPaths.add(uuid);
    }

    public boolean contains(Material material) {
        return this.pathMaterials.containsKey(material);
    }

    public Material getChangedMaterial(Material material) {
        return this.pathMaterials.get(material).getRandom();
    }

    public static PathHandler getInstance() {
        return INSTANCE;
    }
}

