/*
 * Decompiled with CFR 0.152.
 */
package com.codingguru.trailpaths;

import com.codingguru.trailpaths.commands.MainCommand;
import com.codingguru.trailpaths.listeners.PlayerMove;
import com.codingguru.trailpaths.listeners.PlayerQuit;
import com.codingguru.trailpaths.managers.SettingsManager;
import com.codingguru.trailpaths.utils.ConsoleUtil;
import com.codingguru.trailpaths.utils.ServerTypeUtil;
import net.kyori.adventure.platform.bukkit.BukkitAudiences;
import org.bukkit.command.CommandExecutor;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class TrailPaths
extends JavaPlugin {
    private static TrailPaths INSTANCE;
    private SettingsManager settingsManager;
    private BukkitAudiences adventureAPI;
    private ServerTypeUtil serverType;

    public void onEnable() {
        INSTANCE = this;
        this.setupServerType();
        ConsoleUtil.sendPluginSetup();
        this.saveDefaultConfig();
        this.settingsManager = new SettingsManager();
        this.settingsManager.setup((Plugin)this);
        if (this.getConfig().getBoolean("use-mini-message")) {
            this.adventureAPI = BukkitAudiences.create((Plugin)this);
        }
        this.getCommand("trails").setExecutor((CommandExecutor)new MainCommand());
        this.getServer().getPluginManager().registerEvents((Listener)new PlayerQuit(), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new PlayerMove(), (Plugin)this);
    }

    private void setupServerType() {
        try {
            Class.forName("io.papermc.paper.threadedregions.RegionizedServer");
            this.serverType = ServerTypeUtil.FOLIA;
            return;
        }
        catch (ClassNotFoundException classNotFoundException) {
            try {
                Class.forName("io.papermc.paper.ServerBuildInfo");
                this.serverType = ServerTypeUtil.PAPER;
                return;
            }
            catch (ClassNotFoundException classNotFoundException2) {
                this.serverType = ServerTypeUtil.SPIGOT;
                return;
            }
        }
    }

    public ServerTypeUtil getServerType() {
        return this.serverType;
    }

    public BukkitAudiences getAdventure() {
        return this.adventureAPI;
    }

    public SettingsManager getSettingsManager() {
        return this.settingsManager;
    }

    public static TrailPaths getInstance() {
        return INSTANCE;
    }
}

