/*
 * Decompiled with CFR 0.152.
 */
package com.codingguru.inventorystacks.listeners.itemmeta;

import com.codingguru.inventorystacks.InventoryStacks;
import com.codingguru.inventorystacks.handlers.ItemHandler;
import com.codingguru.inventorystacks.scheduler.Schedule;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockDispenseEvent;
import org.bukkit.event.block.CrafterCraftEvent;
import org.bukkit.event.entity.EntityPickupItemEvent;
import org.bukkit.event.entity.ItemSpawnEvent;
import org.bukkit.event.inventory.FurnaceSmeltEvent;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryMoveItemEvent;
import org.bukkit.event.inventory.InventoryPickupItemEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class UpdateItemMetaListener
implements Listener {
    private final Set<Integer> scheduled = Collections.newSetFromMap(new ConcurrentHashMap());

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onInventoryClick(InventoryClickEvent e) {
        this.callNow(e.getCurrentItem());
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onEntityPickup(EntityPickupItemEvent e) {
        this.callNow(e.getItem().getItemStack());
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onInventoryPickupItem(InventoryPickupItemEvent e) {
        this.callNow(e.getItem().getItemStack());
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onInventoryMove(InventoryMoveItemEvent e) {
        this.callNow(e.getItem());
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onBlockDispense(BlockDispenseEvent e) {
        this.callLater(e.getItem());
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onItemSpawn(ItemSpawnEvent e) {
        this.callLater(e.getEntity().getItemStack());
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onPrepareCrafter(CrafterCraftEvent e) {
        this.callLater(e.getResult());
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onFurnaceSmelt(FurnaceSmeltEvent e) {
        this.callLater(e.getResult());
    }

    private void callNow(ItemStack stack) {
        if (!this.shouldHandle(stack)) {
            return;
        }
        ItemHandler.getInstance().applyItem(false, stack);
    }

    private void callLater(final ItemStack stack) {
        if (!this.shouldHandle(stack)) {
            return;
        }
        final int key = System.identityHashCode(stack);
        if (!this.scheduled.add(key)) {
            return;
        }
        Schedule stackApplyTask = new Schedule(){

            @Override
            public void run() {
                try {
                    ItemHandler.getInstance().applyItem(false, stack);
                }
                finally {
                    UpdateItemMetaListener.this.scheduled.remove(key);
                }
            }
        };
        stackApplyTask.runTaskLater(1L);
    }

    private boolean shouldHandle(ItemStack stack) {
        if (stack == null) {
            return false;
        }
        if (stack.getType().isAir()) {
            return false;
        }
        if (!ItemHandler.getInstance().hasUpdatedStack(stack)) {
            this.handleCleanup(stack);
            return false;
        }
        return true;
    }

    private void handleCleanup(ItemStack stack) {
        FileConfiguration config = InventoryStacks.getInstance().getConfig();
        if (!config.getBoolean("auto-stack-cleanup")) {
            return;
        }
        ItemMeta meta = stack.getItemMeta();
        if (meta == null) {
            return;
        }
        if (!meta.hasMaxStackSize()) {
            return;
        }
        meta.setMaxStackSize(null);
        stack.setItemMeta(meta);
    }
}

