/*
 * Decompiled with CFR 0.152.
 */
package com.codingguru.inventorystacks;

import com.codingguru.inventorystacks.commands.ReloadCmd;
import com.codingguru.inventorystacks.commands.StackCmd;
import com.codingguru.inventorystacks.handlers.ItemHandler;
import com.codingguru.inventorystacks.listeners.correction.BlockDispense;
import com.codingguru.inventorystacks.listeners.correction.FurnaceBurn;
import com.codingguru.inventorystacks.listeners.correction.InventoryClick;
import com.codingguru.inventorystacks.listeners.correction.InventoryMoveItem;
import com.codingguru.inventorystacks.listeners.correction.PlayerBucketEmpty;
import com.codingguru.inventorystacks.listeners.correction.PlayerInteract;
import com.codingguru.inventorystacks.listeners.correction.PlayerItemConsume;
import com.codingguru.inventorystacks.listeners.general.BlockPlace;
import com.codingguru.inventorystacks.listeners.general.Commands;
import com.codingguru.inventorystacks.listeners.general.PlayerItemDamage;
import com.codingguru.inventorystacks.listeners.itemmeta.UpdateItemMetaListener;
import com.codingguru.inventorystacks.managers.SettingsManager;
import com.codingguru.inventorystacks.util.ConsoleUtil;
import net.kyori.adventure.platform.bukkit.BukkitAudiences;
import org.bukkit.command.CommandExecutor;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class InventoryStacks
extends JavaPlugin {
    private static InventoryStacks INSTANCE;
    private SettingsManager settingsManager;
    private BukkitAudiences adventureAPI;

    public void onEnable() {
        INSTANCE = this;
        ConsoleUtil.sendPluginStartSetup();
        this.saveDefaultConfig();
        ItemHandler.getInstance().setup();
        this.getCommand("stack").setExecutor((CommandExecutor)new StackCmd());
        this.getCommand("stacks").setExecutor((CommandExecutor)new ReloadCmd());
        this.getCommand("inventorystacks").setExecutor((CommandExecutor)new ReloadCmd());
        this.settingsManager = new SettingsManager();
        this.settingsManager.setup((Plugin)this);
        if (this.getConfig().getBoolean("use-mini-message")) {
            this.adventureAPI = BukkitAudiences.create((Plugin)this);
        }
        long itemChangeDelay = InventoryStacks.getInstance().getConfig().getLong("item-change-delay", 2L);
        this.getServer().getPluginManager().registerEvents((Listener)new Commands(), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new PlayerItemDamage(itemChangeDelay), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new BlockPlace(itemChangeDelay), (Plugin)this);
        if (ItemHandler.getInstance().isUsingModernAPI()) {
            this.getServer().getPluginManager().registerEvents((Listener)new UpdateItemMetaListener(), (Plugin)this);
        } else {
            this.getServer().getPluginManager().registerEvents((Listener)new PlayerBucketEmpty(itemChangeDelay), (Plugin)this);
            this.getServer().getPluginManager().registerEvents((Listener)new PlayerItemConsume(itemChangeDelay), (Plugin)this);
            this.getServer().getPluginManager().registerEvents((Listener)new InventoryClick(), (Plugin)this);
            this.getServer().getPluginManager().registerEvents((Listener)new InventoryMoveItem(), (Plugin)this);
            this.getServer().getPluginManager().registerEvents((Listener)new FurnaceBurn(), (Plugin)this);
            this.getServer().getPluginManager().registerEvents((Listener)new PlayerInteract(), (Plugin)this);
            this.getServer().getPluginManager().registerEvents((Listener)new BlockDispense(), (Plugin)this);
        }
        ConsoleUtil.sendPluginEndSetup();
    }

    public BukkitAudiences getAdventure() {
        return this.adventureAPI;
    }

    public SettingsManager getSettingsManager() {
        return this.settingsManager;
    }

    public static InventoryStacks getInstance() {
        return INSTANCE;
    }
}

