/*
 * Decompiled with CFR 0.152.
 */
package com.codingguru.inventorystacks.listeners.correction;

import com.codingguru.inventorystacks.util.VersionUtil;
import com.codingguru.inventorystacks.util.XMaterial;
import java.util.HashMap;
import java.util.Objects;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.Dispenser;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.Directional;
import org.bukkit.entity.Item;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockDispenseEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.potion.PotionType;

public class BlockDispense
implements Listener {
    @EventHandler(ignoreCancelled=true)
    public void onDispenserWaterBottle(BlockDispenseEvent e) {
        if (!VersionUtil.v1_19_R1.isServerVersionHigher()) {
            return;
        }
        ItemStack stack = e.getItem();
        if (!this.isWaterBottle(stack)) {
            return;
        }
        Block dispenserBlock = e.getBlock();
        if (dispenserBlock == null) {
            return;
        }
        BlockFace facing = this.getDispenserFacing(dispenserBlock);
        if (facing == null) {
            return;
        }
        Block target = dispenserBlock.getRelative(facing);
        if (!this.canBecomeMud(target)) {
            return;
        }
        e.setCancelled(true);
        Material mud = XMaterial.matchXMaterial("MUD").map(XMaterial::get).orElse(null);
        if (mud == null) {
            return;
        }
        target.setType(mud, true);
        Dispenser dispenser = (Dispenser)dispenserBlock.getState();
        Inventory inv = dispenser.getInventory();
        int slot = this.findMatchingSlot(inv, stack);
        if (slot == -1) {
            return;
        }
        ItemStack inSlot = inv.getItem(slot);
        if (inSlot == null) {
            return;
        }
        inSlot.setAmount(inSlot.getAmount() - 1);
        inv.setItem(slot, (ItemStack)(inSlot.getAmount() > 0 ? inSlot : null));
        Material glassBottle = XMaterial.matchXMaterial("GLASS_BOTTLE").map(XMaterial::get).orElse(null);
        if (glassBottle != null) {
            HashMap overflow = inv.addItem(new ItemStack[]{new ItemStack(glassBottle, 1)});
            overflow.values().forEach(item -> {
                Item item2 = dispenserBlock.getWorld().dropItemNaturally(dispenserBlock.getLocation().add(0.5, 0.5, 0.5), item);
            });
        }
    }

    private boolean isWaterBottle(ItemStack item) {
        if (item == null) {
            return false;
        }
        if (item.getType() != XMaterial.matchXMaterial("POTION").map(XMaterial::get).orElse(null)) {
            return false;
        }
        if (!(item.getItemMeta() instanceof PotionMeta)) {
            return false;
        }
        PotionMeta meta = (PotionMeta)item.getItemMeta();
        if (meta.hasCustomEffects()) {
            return false;
        }
        return meta.getBasePotionData().getType() == PotionType.WATER;
    }

    private boolean canBecomeMud(Block block) {
        Material type = block.getType();
        return type == Material.DIRT || type == Material.COARSE_DIRT || type == Material.ROOTED_DIRT;
    }

    private int findMatchingSlot(Inventory inv, ItemStack needle) {
        ItemStack[] contents = inv.getContents();
        int i = 0;
        while (i < contents.length) {
            ItemStack s = contents[i];
            if (s != null && s.getType() == needle.getType() && Objects.equals(s.getItemMeta(), needle.getItemMeta())) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private BlockFace getDispenserFacing(Block block) {
        BlockData data = block.getBlockData();
        if (data instanceof Directional) {
            return ((Directional)data).getFacing();
        }
        return null;
    }
}

