/*
 * Decompiled with CFR 0.152.
 */
package com.codingguru.inventorystacks.handlers;

import com.codingguru.inventorystacks.InventoryStacks;
import com.codingguru.inventorystacks.items.StackSizeApplier;
import com.codingguru.inventorystacks.util.ConsoleUtil;
import com.codingguru.inventorystacks.util.ReflectionLegacyUtil;
import com.codingguru.inventorystacks.util.ServerTypeUtil;
import com.codingguru.inventorystacks.util.StackSizeApplierUtil;
import com.codingguru.inventorystacks.util.VersionUtil;
import com.codingguru.inventorystacks.util.XMaterial;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class ItemHandler {
    private static final ItemHandler INSTANCE = new ItemHandler();
    private static final InventoryStacks PLUGIN = InventoryStacks.getInstance();
    private final Map<XMaterial, Integer> cachedDefaultStackSizes = Maps.newHashMap();
    private final Map<XMaterial, Integer> cachedUpdatedStackSizes = Maps.newHashMap();
    private VersionUtil serverVersion;
    private ServerTypeUtil serverType;
    private StackSizeApplier applier;

    private ItemHandler() {
    }

    public static ItemHandler getInstance() {
        return INSTANCE;
    }

    public void setup() {
        if (!this.setupServerVersion()) {
            String pkg = Bukkit.getServer().getClass().getPackage().getName();
            String versionFound = pkg.substring(pkg.lastIndexOf(46) + 1);
            ConsoleUtil.warning("THE VERSION: " + versionFound + " IS CURRENTLY UNSUPPORTED. DISABLING PLUGIN...");
            Bukkit.getPluginManager().disablePlugin((Plugin)InventoryStacks.getInstance());
            return;
        }
        this.setupServerType();
        this.applier = StackSizeApplierUtil.create();
        this.applier.setup();
        ConsoleUtil.message(ChatColor.GREEN + "Loaded Version: " + ChatColor.YELLOW + ItemHandler.getInstance().getServerVersion().toString());
        ConsoleUtil.message(ChatColor.GREEN + "Server Type: " + ChatColor.YELLOW + ItemHandler.getInstance().getServerType().toString());
        ConsoleUtil.message(ChatColor.GREEN + "Stack Sizing Mode: " + ChatColor.YELLOW + (this.applier.isModernApi() ? "ItemMeta API (1.20.5+)" : "Legacy NMS"));
        ConsoleUtil.message("");
        this.applyConfiguredStacks();
    }

    private boolean setupServerVersion() {
        String pkg = Bukkit.getServer().getClass().getPackage().getName();
        String versionFound = pkg.substring(pkg.lastIndexOf(46) + 1);
        String cleanVersion = Bukkit.getBukkitVersion().split("-")[0];
        String[] parts = cleanVersion.split("\\.");
        if (parts.length < 2) {
            return false;
        }
        String majorMinor = String.valueOf(parts[0]) + "." + parts[1];
        if (versionFound.equalsIgnoreCase("craftbukkit")) {
            if (majorMinor.equals("1.21")) {
                this.serverVersion = VersionUtil.v1_21;
                return true;
            }
            if (majorMinor.equals("1.20")) {
                this.serverVersion = VersionUtil.v1_20;
                return true;
            }
            return false;
        }
        VersionUtil[] versionUtilArray = VersionUtil.values();
        int n = versionUtilArray.length;
        int n2 = 0;
        while (n2 < n) {
            VersionUtil version = versionUtilArray[n2];
            if (versionFound.contains(version.name())) {
                this.serverVersion = version;
                return true;
            }
            ++n2;
        }
        return false;
    }

    private void setupServerType() {
        try {
            Class.forName("io.papermc.paper.threadedregions.RegionizedServer");
            this.serverType = ServerTypeUtil.FOLIA;
            return;
        }
        catch (ClassNotFoundException classNotFoundException) {
            try {
                Class.forName("io.papermc.paper.ServerBuildInfo");
                this.serverType = ServerTypeUtil.PAPER;
                return;
            }
            catch (ClassNotFoundException classNotFoundException2) {
                this.serverType = ServerTypeUtil.SPIGOT;
                return;
            }
        }
    }

    public boolean isUsingModernAPI() {
        return this.applier.isModernApi();
    }

    public void applyItem(boolean isStartUp, ItemStack stack) {
        XMaterial xMat = XMaterial.matchXMaterial(stack);
        if (xMat == null) {
            return;
        }
        if (!this.cachedUpdatedStackSizes.containsKey(xMat)) {
            return;
        }
        int amount = this.cachedUpdatedStackSizes.get(xMat);
        this.applier.applyItem(isStartUp, stack, amount);
    }

    public boolean hasEditedStackSize(Material material) {
        if (material == Material.AIR) {
            return false;
        }
        XMaterial xMaterial = XMaterial.matchXMaterial(material);
        if (xMaterial == null) {
            return false;
        }
        return this.hasEditedStackSize(xMaterial);
    }

    public boolean hasEditedStackSize(XMaterial xMaterial) {
        return this.cachedUpdatedStackSizes.containsKey(xMaterial);
    }

    public void cacheMaterialStackSize(XMaterial xMaterial, int newStackSize, int oldStackSize) {
        this.cachedUpdatedStackSizes.putIfAbsent(xMaterial, newStackSize);
        if (this.applier.isModernApi()) {
            return;
        }
        this.cachedDefaultStackSizes.putIfAbsent(xMaterial, oldStackSize);
    }

    public void reloadInventoryStacks() {
        this.resetMaterialsToDefaultValues();
        this.cachedDefaultStackSizes.clear();
        this.cachedUpdatedStackSizes.clear();
        this.applyConfiguredStacks();
    }

    private void applyConfiguredStacks() {
        Map<Object, Object> resolvedStacks = new HashMap();
        if (PLUGIN.getConfig().isSet("items")) {
            resolvedStacks = this.resolveConfiguredItems(PLUGIN.getConfig().getConfigurationSection("items").getKeys(true));
            for (Map.Entry<Object, Object> e : resolvedStacks.entrySet()) {
                String matName = (String)e.getKey();
                int size = (Integer)e.getValue();
                XMaterial xMat = XMaterial.matchXMaterial(matName).orElse(null);
                if (xMat == null) {
                    ConsoleUtil.warning(ChatColor.RED + "The Item: " + matName + " does not exist. Check MATERIAL_LIST.txt for all up to date item names.");
                    continue;
                }
                Material mat = xMat.get();
                if (mat == null || !this.isItem(mat)) continue;
                this.cacheMaterialStackSize(xMat, size, mat.getMaxStackSize());
                this.applier.applyItem(true, xMat.parseItem(), size);
                ConsoleUtil.info(ChatColor.YELLOW + "Successfully set " + matName + " stack size to: " + size);
            }
        }
        if (PLUGIN.getConfig().getBoolean("max-stack-for-all-items.enabled")) {
            int stackSize = this.validateStackSize(PLUGIN.getConfig().getInt("max-stack-for-all-items.amount"), "ALL");
            List configExemptList = PLUGIN.getConfig().getStringList("max-stack-for-all-items.whitelist");
            Set<String> exemptMaterials = configExemptList.stream().filter(Objects::nonNull).map(s -> s.toUpperCase()).collect(Collectors.toSet());
            resolvedStacks.keySet().forEach(name -> {
                boolean bl = exemptMaterials.add(name.toUpperCase());
            });
            this.updateAllItems(exemptMaterials, stackSize);
        }
    }

    private Map<String, Integer> resolveConfiguredItems(Collection<String> keys) {
        HashMap<String, Integer> resolved = new HashMap<String, Integer>();
        XMaterial[] allMaterials = XMaterial.VALUES;
        for (String key : keys) {
            Pattern pattern;
            if (key == null || key.isEmpty() || !PLUGIN.getConfig().isInt("items." + key)) continue;
            int stackSize = this.validateStackSize(PLUGIN.getConfig().getInt("items." + key), key);
            try {
                pattern = Pattern.compile(key, 2);
            }
            catch (PatternSyntaxException ex) {
                ConsoleUtil.warning(ChatColor.RED + "Invalid regex in items: '" + key + "': " + ex.getDescription());
                continue;
            }
            XMaterial[] xMaterialArray = allMaterials;
            int n = allMaterials.length;
            int n2 = 0;
            while (n2 < n) {
                XMaterial material = xMaterialArray[n2];
                String name = material.name();
                if (pattern.matcher(name).matches()) {
                    resolved.putIfAbsent(name.toUpperCase(), stackSize);
                }
                ++n2;
            }
        }
        return resolved;
    }

    private void updateAllItems(Set<String> exemptMaterials, int stackSize) {
        HashSet<Material> processed = new HashSet<Material>();
        XMaterial[] xMaterialArray = XMaterial.VALUES;
        int n = XMaterial.VALUES.length;
        int n2 = 0;
        while (n2 < n) {
            Material mat;
            XMaterial xMat = xMaterialArray[n2];
            if (xMat.isSupported() && (mat = xMat.get()) != null && this.isItem(mat) && !exemptMaterials.contains(mat.name().toUpperCase()) && !exemptMaterials.contains(xMat.name().toUpperCase()) && processed.add(mat)) {
                this.cacheMaterialStackSize(xMat, stackSize, mat.getMaxStackSize());
                this.applier.applyItem(true, xMat.parseItem(), stackSize);
                ConsoleUtil.info(ChatColor.YELLOW + "Successfully set " + mat.name() + " stack size to: " + stackSize);
            }
            ++n2;
        }
    }

    public boolean isItem(Material mat) {
        if (mat == null) {
            return false;
        }
        try {
            return mat.isItem();
        }
        catch (NoSuchMethodError ignored) {
            return ReflectionLegacyUtil.hasItemForm(mat) != null;
        }
    }

    private int validateStackSize(int stackSize, String itemName) {
        int absoluteMaxStackSize = this.serverVersion.getAbsoluteMaxStackSize();
        if (stackSize > absoluteMaxStackSize) {
            ConsoleUtil.warning("Stack size: " + stackSize + " can not be set for " + itemName + " item(s) over " + absoluteMaxStackSize + ". Defaulting to max value...");
            return absoluteMaxStackSize;
        }
        if (stackSize < 1) {
            ConsoleUtil.warning(ChatColor.RED + "Unable to set stack size to: " + stackSize + " for " + itemName + " item(s). Defaulting to 1...");
            stackSize = 1;
        }
        return stackSize;
    }

    private void resetMaterialsToDefaultValues() {
        if (this.applier.isModernApi()) {
            return;
        }
        for (Map.Entry<XMaterial, Integer> entry : this.cachedDefaultStackSizes.entrySet()) {
            int defaultSize = entry.getValue();
            this.applier.applyItem(true, entry.getKey().parseItem(), defaultSize);
        }
    }

    public VersionUtil getServerVersion() {
        return this.serverVersion;
    }

    public ServerTypeUtil getServerType() {
        return this.serverType;
    }
}

