/*
 * Decompiled with CFR 0.152.
 */
package com.codingguru.inventorystacks.util.reflection.proxy.generator;

import com.codingguru.inventorystacks.util.reflection.XAccessFlag;
import com.codingguru.inventorystacks.util.reflection.jvm.objects.ReflectedObject;
import com.codingguru.inventorystacks.util.reflection.proxy.ReflectiveProxyObject;
import com.codingguru.inventorystacks.util.reflection.proxy.annotations.Constructor;
import com.codingguru.inventorystacks.util.reflection.proxy.annotations.Final;
import com.codingguru.inventorystacks.util.reflection.proxy.annotations.Ignore;
import com.codingguru.inventorystacks.util.reflection.proxy.annotations.Private;
import com.codingguru.inventorystacks.util.reflection.proxy.annotations.Protected;
import com.codingguru.inventorystacks.util.reflection.proxy.annotations.Proxify;
import com.codingguru.inventorystacks.util.reflection.proxy.annotations.Static;
import java.io.BufferedWriter;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.annotation.Repeatable;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Array;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;
import java.util.StringJoiner;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class XProxifier {
    private static final String MEMBER_SPACES = "    ";
    private final StringBuilder writer = new StringBuilder(1000);
    private final Set<String> imports = new HashSet<String>(20);
    private final String proxifiedClassName;
    private final Class<?> clazz;
    private final boolean generateIntelliJAnnotations = true;
    private final boolean generateInaccessibleMembers = true;
    private final boolean copyAnnotations = true;
    private final boolean writeComments = true;
    private final boolean writeInfoAnnotationsAsComments = true;
    private boolean disableIDEFormatting;
    private Function<Class<?>, String> remapper;

    public XProxifier(Class<?> clazz) {
        this.clazz = clazz;
        this.proxifiedClassName = clazz.getSimpleName() + "Proxified";
        this.proxify();
    }

    private static Class<?> unwrapArrayType(Class<?> clazz) {
        while (clazz.isArray()) {
            clazz = clazz.getComponentType();
        }
        return clazz;
    }

    private void imports(Class<?> clazz) {
        if (!(clazz = XProxifier.unwrapArrayType(clazz)).isPrimitive() && !clazz.getPackage().getName().equals("java.lang")) {
            this.imports.add(clazz.getName().replace('$', '.'));
        }
    }

    private void writeComments(String ... comments) {
        boolean multiLine;
        boolean bl = multiLine = comments.length > 1;
        if (!multiLine) {
            this.writer.append("// ").append(comments[0]).append('\n');
        }
        this.writer.append("/**\n");
        for (String comment : comments) {
            this.writer.append(" * ");
            this.writer.append(comment);
            this.writer.append('\n');
        }
        this.writer.append(" */\n");
    }

    private void writeThrownExceptions(Class<?>[] exceptionTypes) {
        if (exceptionTypes == null || exceptionTypes.length == 0) {
            return;
        }
        this.writer.append(" throws ");
        StringJoiner exs = new StringJoiner(", ");
        for (Class<?> ex : exceptionTypes) {
            this.imports(ex);
            exs.add(ex.getSimpleName());
        }
        this.writer.append(exs);
    }

    private void writeMember(ReflectedObject jvm) {
        this.writeMember(jvm, false);
    }

    private void writeMember(ReflectedObject jvm, boolean generateGetterField) {
        this.writer.append(this.annotationsToString(true, true, jvm));
        Set<XAccessFlag> accessFlags = jvm.accessFlags();
        if (accessFlags.contains((Object)XAccessFlag.PRIVATE)) {
            this.writeAnnotation(Private.class, new String[0]);
        }
        if (accessFlags.contains((Object)XAccessFlag.PROTECTED)) {
            this.writeAnnotation(Protected.class, new String[0]);
        }
        if (accessFlags.contains((Object)XAccessFlag.STATIC)) {
            this.writeAnnotation(Static.class, new String[0]);
        }
        if (accessFlags.contains((Object)XAccessFlag.FINAL)) {
            this.writeAnnotation(Final.class, new String[0]);
        }
        switch (jvm.type()) {
            case CONSTRUCTOR: {
                this.writeAnnotation(Constructor.class, new String[0]);
                this.writeAnnotation("NotNull", new String[0]);
                java.lang.reflect.Constructor ctor = (java.lang.reflect.Constructor)jvm.unreflect();
                String contractParams = Arrays.stream(ctor.getParameterTypes()).map(x -> "_").collect(Collectors.joining(", "));
                this.writeAnnotation("Contract", "value = \"" + contractParams + " -> new\"", "pure = true");
                break;
            }
            case FIELD: {
                this.writeAnnotation(com.codingguru.inventorystacks.util.reflection.proxy.annotations.Field.class, new String[0]);
                if (generateGetterField) {
                    this.writeAnnotation("Contract", "pure = true");
                    break;
                }
                this.writeAnnotation("Contract", "mutates = \"this\"");
            }
        }
        StringJoiner parameters = new StringJoiner(", ", "(", ")");
        Class<?>[] exceptionTypes = null;
        this.writer.append(MEMBER_SPACES);
        switch (jvm.type()) {
            case CONSTRUCTOR: {
                java.lang.reflect.Constructor constructor = (java.lang.reflect.Constructor)jvm.unreflect();
                exceptionTypes = constructor.getExceptionTypes();
                this.writer.append(this.proxifiedClassName).append(' ').append("construct");
                this.writeParameters(parameters, constructor.getParameters());
                break;
            }
            case FIELD: {
                Field field = (Field)jvm.unreflect();
                this.imports(field.getType());
                if (generateGetterField) {
                    this.writer.append(field.getType().getSimpleName());
                } else {
                    this.writer.append("void");
                    parameters.add(field.getType().getSimpleName() + " value");
                }
                this.writer.append(' ');
                this.writer.append(jvm.name());
                break;
            }
            case METHOD: {
                Method method = (Method)jvm.unreflect();
                exceptionTypes = method.getExceptionTypes();
                this.imports(method.getReturnType());
                this.writer.append(method.getReturnType().getSimpleName());
                this.writer.append(' ');
                this.writer.append(jvm.name());
                this.writeParameters(parameters, method.getParameters());
            }
        }
        this.writer.append(parameters);
        this.writeThrownExceptions(exceptionTypes);
        this.writer.append(";\n\n");
    }

    private static Object[] getArray(Object val) {
        if (val instanceof Object[]) {
            return (Object[])val;
        }
        int arrlength = Array.getLength(val);
        Object[] outputArray = new Object[arrlength];
        for (int i = 0; i < arrlength; ++i) {
            outputArray[i] = Array.get(val, i);
        }
        return outputArray;
    }

    private String constantToString(Object obj) {
        if (obj instanceof String) {
            return '\"' + obj.toString() + '\"';
        }
        if (obj instanceof Class) {
            Class clazz = (Class)obj;
            this.imports(clazz);
            return clazz.getSimpleName() + ".class";
        }
        if (obj instanceof Annotation) {
            Annotation annotation = (Annotation)obj;
            return this.annotationToString(annotation);
        }
        if (obj.getClass().isEnum()) {
            this.imports(obj.getClass());
            return obj.getClass().getSimpleName() + '.' + ((Enum)obj).name();
        }
        if (obj.getClass().isArray()) {
            Object[] array = XProxifier.getArray(obj);
            if (array.length == 0) {
                return "{}";
            }
            StringJoiner builder = array.length == 1 ? new StringJoiner(", ") : new StringJoiner(", ", "{", "}");
            for (Object element : array) {
                builder.add(this.constantToString(element));
            }
            return builder.toString();
        }
        return obj.toString();
    }

    private String annotationsToString(boolean member, boolean newLine, AnnotatedElement annotatable) {
        StringJoiner builder = new StringJoiner((newLine ? Character.valueOf('\n') : "") + (member ? MEMBER_SPACES : ""), member ? MEMBER_SPACES : "", newLine ? "\n" : "").setEmptyValue("");
        for (Annotation annotation : annotatable.getAnnotations()) {
            Annotation[] unwrapped = XProxifier.unwrapRepeatElement(annotation);
            if (unwrapped != null) {
                for (Annotation inner : unwrapped) {
                    builder.add(this.annotationToString(inner));
                }
                continue;
            }
            builder.add(this.annotationToString(annotation));
        }
        return builder.toString();
    }

    private static Annotation[] unwrapRepeatElement(Annotation annotation) {
        try {
            Repeatable repeatable;
            Class<?> rawReturn;
            Method method = annotation.annotationType().getDeclaredMethod("value", new Class[0]);
            if (method.getReturnType().isArray() && (rawReturn = XProxifier.unwrapArrayType(method.getReturnType())).isAnnotation() && (repeatable = rawReturn.getAnnotation(Repeatable.class)) != null && repeatable.value() == annotation.annotationType()) {
                try {
                    return (Annotation[])method.invoke((Object)annotation, new Object[0]);
                }
                catch (IllegalAccessException | InvocationTargetException e) {
                    throw new IllegalArgumentException(e);
                }
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        return null;
    }

    private String annotationToString(Annotation annotation) {
        String annotationValues;
        ArrayList<String> builder = new ArrayList<String>();
        boolean visitedValue = false;
        for (Method entry : annotation.annotationType().getDeclaredMethods()) {
            try {
                entry.setAccessible(true);
                String key = entry.getName();
                Object value = entry.invoke((Object)annotation, new Object[0]);
                try {
                    @Nullable Object defaultValue = entry.getDefaultValue();
                    if (defaultValue != null && (defaultValue.getClass().isArray() ? Arrays.equals(XProxifier.getArray(defaultValue), XProxifier.getArray(value)) : value.equals(defaultValue))) {
                        continue;
                    }
                }
                catch (TypeNotPresentException typeNotPresentException) {
                    // empty catch block
                }
                if (key.equals("value")) {
                    visitedValue = true;
                }
                builder.add(key + " = " + this.constantToString(value));
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new IllegalStateException("Failed to get annotation value " + entry, e);
            }
        }
        this.imports(annotation.annotationType());
        if (builder.isEmpty()) {
            annotationValues = "";
        } else if (builder.size() == 1 && visitedValue) {
            annotationValues = (String)builder.get(0);
            int equalsSign = annotationValues.indexOf(61);
            annotationValues = '(' + annotationValues.substring(equalsSign + 2) + ')';
        } else {
            annotationValues = '(' + String.join((CharSequence)", ", builder) + ')';
        }
        return '@' + annotation.annotationType().getSimpleName() + annotationValues;
    }

    private StringJoiner writeParameters(StringJoiner joiner, Parameter[] parameters) {
        for (Parameter parameter : parameters) {
            this.imports(parameter.getType());
            String type = parameter.isVarArgs() ? parameter.getType().getSimpleName() + "... " : parameter.getType().getSimpleName();
            String annotations = this.annotationsToString(false, false, parameter);
            joiner.add(annotations + (annotations.isEmpty() ? "" : " ") + type + ' ' + parameter.getName());
        }
        return joiner;
    }

    private void writeAnnotation(Class<?> annotation, String ... values) {
        this.writeAnnotation(true, annotation, values);
    }

    private void writeAnnotation(boolean member, Class<?> annotation, String ... values) {
        this.imports(annotation);
        this.writeAnnotation(member, annotation.getSimpleName(), values);
    }

    private void writeAnnotation(String annotation, String ... values) {
        this.writeAnnotation(true, annotation, values);
    }

    private void writeAnnotation(boolean member, String annotation, String ... values) {
        if (member) {
            this.writer.append(MEMBER_SPACES);
        }
        this.writer.append('@').append(annotation);
        if (values.length != 0) {
            StringJoiner valueJoiner = new StringJoiner(", ", "(", ")");
            for (String value : values) {
                valueJoiner.add(value);
            }
            this.writer.append(valueJoiner);
        }
        this.writer.append('\n');
    }

    private void proxify() {
        Field[] declaredFields;
        if (this.disableIDEFormatting) {
            this.writer.append("// ").append("@formatter:").append("OFF").append('\n');
        }
        this.writeComments("This is a generated proxified class for " + this.clazz.getSimpleName() + ". However, you might", "want to review each member and correct its annotations when needed.", "<p>", "It's also recommended to use your IDE's code formatter to adjust", "imports and spaces according to your settings.", "In IntelliJ, this can be done by with Ctrl+Alt+L", "<p>", "Full Target Class Path:", this.clazz.getName());
        this.writer.append(this.annotationsToString(false, true, this.clazz));
        this.writeAnnotation(false, Proxify.class, "target = " + this.clazz.getSimpleName() + ".class");
        if (!XAccessFlag.PUBLIC.isSet(this.clazz.getModifiers())) {
            this.writeAnnotation(false, Private.class, new String[0]);
        }
        if (XAccessFlag.FINAL.isSet(this.clazz.getModifiers())) {
            this.writeAnnotation(false, Final.class, new String[0]);
            this.writeAnnotation(false, "ApiStatus.NonExtendable", new String[0]);
        }
        this.writer.append("public interface ").append(this.proxifiedClassName).append(" extends ").append(ReflectiveProxyObject.class.getSimpleName()).append(" {\n");
        for (Field field : declaredFields = this.clazz.getDeclaredFields()) {
            if (field.isSynthetic()) continue;
            if (!XAccessFlag.FINAL.isSet(field.getModifiers())) {
                this.writeMember(ReflectedObject.of(field), false);
            }
            this.writeMember(ReflectedObject.of(field), true);
        }
        if (declaredFields.length != 0) {
            this.writer.append('\n');
        }
        java.lang.reflect.Constructor<?>[] declaredConstructors = this.clazz.getDeclaredConstructors();
        for (java.lang.reflect.Constructor<?> constructor : declaredConstructors) {
            if (constructor.isSynthetic()) continue;
            this.writeMember(ReflectedObject.of(constructor));
        }
        if (declaredConstructors.length != 0) {
            this.writer.append('\n');
        }
        for (Executable executable : this.clazz.getDeclaredMethods()) {
            if (((Method)executable).getDeclaringClass() == Object.class || ((Method)executable).isSynthetic() || ((Method)executable).isBridge()) continue;
            this.writeMember(ReflectedObject.of((Method)executable));
        }
        this.writer.append('\n');
        this.writeAnnotation(Ignore.class, new String[0]);
        this.writeAnnotation("NotNull", new String[0]);
        this.writeAnnotation("ApiStatus.OverrideOnly", new String[0]);
        this.writeAnnotation("Contract", "value = \"_ -> new\"", "pure = true");
        this.writer.append(MEMBER_SPACES).append(this.proxifiedClassName).append(" bindTo(@NotNull Object instance);\n");
        this.writer.append("}\n");
        this.finalizeString();
    }

    private void finalizeString() {
        StringBuilder whole = new StringBuilder(this.writer.length() + this.imports.size() * 100);
        whole.append("import org.jetbrains.annotations.*;\n");
        ArrayList<String> sortedImports = new ArrayList<String>(this.imports);
        sortedImports.sort(Comparator.naturalOrder());
        for (String anImport : sortedImports) {
            whole.append("import ").append(anImport).append(";\n");
        }
        whole.append('\n');
        this.writer.insert(0, whole);
        this.imports(ReflectiveProxyObject.class);
    }

    public String getString() {
        if (this.writer.length() == 0) {
            this.proxify();
        }
        return this.writer.toString();
    }

    public void writeTo(Path path) {
        if (Files.isDirectory(path, new LinkOption[0])) {
            path = path.resolve(this.proxifiedClassName + ".java");
        }
        try (BufferedWriter writer = Files.newBufferedWriter(path, StandardCharsets.UTF_8, StandardOpenOption.CREATE, StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING);){
            writer.write(this.getString());
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }
}

