/*
 * Decompiled with CFR 0.152.
 */
package com.codingguru.inventorystacks.util.profiles.objects.cache;

import com.codingguru.inventorystacks.util.profiles.exceptions.MojangAPIRetryException;
import com.codingguru.inventorystacks.util.profiles.gameprofile.MojangGameProfile;
import com.codingguru.inventorystacks.util.profiles.objects.Profileable;
import com.codingguru.inventorystacks.util.reflection.XReflection;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public abstract class CacheableProfileable
implements Profileable {
    protected MojangGameProfile cache;
    protected Throwable lastError;

    @Override
    public final synchronized MojangGameProfile getProfile() {
        if (this.hasExpired(true)) {
            this.lastError = null;
            this.cache = null;
        }
        if (this.lastError != null && !(this.lastError instanceof MojangAPIRetryException)) {
            throw XReflection.throwCheckedException(this.lastError);
        }
        if (this.cache == null) {
            try {
                this.cache = this.cacheProfile();
                this.lastError = null;
            }
            catch (Throwable ex) {
                this.lastError = ex;
                throw ex;
            }
        }
        return this.cache;
    }

    public final boolean hasExpired() {
        return this.hasExpired(false);
    }

    @Override
    public final boolean isReady() {
        return !this.hasExpired(false);
    }

    protected boolean hasExpired(boolean renew) {
        return this.lastError instanceof MojangAPIRetryException;
    }

    @NotNull
    protected abstract MojangGameProfile cacheProfile();

    public final String toString() {
        return this.getClass().getSimpleName() + "[cache=" + this.cache + ", lastError=" + this.lastError + ']';
    }
}

