/*
 * Decompiled with CFR 0.152.
 */
package com.codingguru.inventorystacks.util.profiles.mojang;

import com.codingguru.inventorystacks.util.profiles.PlayerProfiles;
import com.codingguru.inventorystacks.util.profiles.gameprofile.MojangGameProfile;
import com.codingguru.inventorystacks.util.profiles.gameprofile.XGameProfile;
import com.codingguru.inventorystacks.util.profiles.mojang.PlayerProfile;
import com.google.common.base.Strings;
import com.google.common.cache.LoadingCache;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.yggdrasil.ProfileActionType;
import com.mojang.authlib.yggdrasil.ProfileResult;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
abstract class MojangProfileCache {
    MojangProfileCache() {
    }

    abstract void cache(PlayerProfile var1);

    @Nullable
    abstract Optional<GameProfile> get(UUID var1, GameProfile var2);

    protected static final class GameProfileCache
    extends MojangProfileCache {
        private final LoadingCache<GameProfile, GameProfile> insecureProfiles;

        GameProfileCache(LoadingCache<?, ?> insecureProfiles) {
            this.insecureProfiles = insecureProfiles;
        }

        @Override
        void cache(PlayerProfile playerProfile) {
            if (playerProfile.exists()) {
                this.insecureProfiles.put((Object)playerProfile.requestedGameProfile, (Object)playerProfile.fetchedGameProfile);
            } else {
                this.insecureProfiles.put((Object)playerProfile.requestedGameProfile, (Object)PlayerProfiles.NIL);
            }
        }

        @Override
        @Nullable
        Optional<GameProfile> get(UUID realId, GameProfile gameProfile) {
            MojangGameProfile profile = XGameProfile.of(gameProfile);
            String profileName = profile.name();
            if (Strings.isNullOrEmpty((String)profileName) || profileName.equals("XSeries")) {
                return null;
            }
            GameProfile cache = (GameProfile)this.insecureProfiles.getIfPresent((Object)XGameProfile.create(realId, profile.name()).object());
            if (cache == PlayerProfiles.NIL) {
                return Optional.empty();
            }
            return cache == null ? null : Optional.of(cache);
        }
    }

    protected static final class ProfileResultCache
    extends MojangProfileCache {
        private final LoadingCache<UUID, Optional<ProfileResult>> insecureProfiles;

        ProfileResultCache(LoadingCache<?, ?> insecureProfiles) {
            this.insecureProfiles = insecureProfiles;
        }

        @Override
        void cache(PlayerProfile playerProfile) {
            if (playerProfile.exists()) {
                ProfileResult profileResult = new ProfileResult(playerProfile.fetchedGameProfile, playerProfile.profileActions.stream().map(x -> {
                    try {
                        return ProfileActionType.valueOf((String)x);
                    }
                    catch (IllegalArgumentException ex) {
                        return null;
                    }
                }).filter(Objects::nonNull).collect(Collectors.toSet()));
                this.insecureProfiles.put((Object)playerProfile.realUUID, Optional.of(profileResult));
            } else {
                this.insecureProfiles.put((Object)playerProfile.realUUID, Optional.empty());
            }
        }

        @Override
        Optional<GameProfile> get(UUID realId, GameProfile gameProfile) {
            Optional cache = (Optional)this.insecureProfiles.getIfPresent((Object)realId);
            return cache == null ? null : cache.map(ProfileResult::profile);
        }
    }
}

