/*
 * Decompiled with CFR 0.152.
 */
package com.codingguru.inventorystacks.util.profiles.gameprofile;

import com.codingguru.inventorystacks.util.profiles.gameprofile.MojangGameProfile;
import com.codingguru.inventorystacks.util.profiles.gameprofile.NewGameProfile;
import com.codingguru.inventorystacks.util.profiles.gameprofile.OldGameProfile;
import com.codingguru.inventorystacks.util.reflection.XReflection;
import com.google.common.collect.Multimap;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.PropertyMap;
import java.util.UUID;
import javax.annotation.Nullable;

public class XGameProfile {
    private static final boolean USE_RECORDS = XReflection.isRecord(GameProfile.class);

    private XGameProfile() {
    }

    @Nullable
    public static MojangGameProfile of(GameProfile gameProfile) {
        if (gameProfile == null) {
            return null;
        }
        if (USE_RECORDS) {
            return new NewGameProfile(gameProfile);
        }
        return new OldGameProfile(gameProfile);
    }

    public static MojangGameProfile create(UUID id, String name, PropertyMap properties) {
        if (USE_RECORDS) {
            return XGameProfile.of(new GameProfile(id, name, properties));
        }
        GameProfile gameProfile = new GameProfile(id, name);
        MojangGameProfile converted = XGameProfile.of(gameProfile);
        converted.properties().putAll((Multimap)properties);
        return converted;
    }

    public static MojangGameProfile create(UUID id, String name) {
        return XGameProfile.of(new GameProfile(id, name));
    }
}

