/*
 * Decompiled with CFR 0.152.
 */
package com.codingguru.inventorystacks.util;

import com.codingguru.inventorystacks.InventoryStacks;
import com.codingguru.inventorystacks.handlers.ItemHandler;
import com.codingguru.inventorystacks.util.ConsoleUtil;
import com.codingguru.inventorystacks.util.VersionUtil;
import com.codingguru.inventorystacks.util.XMaterial;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;

public final class ReflectionUtil {
    private static final VersionUtil SERVER_VERSION = ItemHandler.getInstance().getServerVersion();
    private static final InventoryStacks PLUGIN = InventoryStacks.getInstance();

    private ReflectionUtil() {
    }

    public static void applyStackSizeToMaterial(Object nmsItem, Material material, int size) {
        try {
            if (nmsItem == null) {
                ConsoleUtil.info(ChatColor.GRAY + "Skipping " + material.name() + " (no item form)");
                return;
            }
            ItemHandler.getInstance().applyStackSizeToNmsItem(nmsItem, size);
            ConsoleUtil.info(ChatColor.YELLOW + "Successfully set " + material.name() + " stack size to: " + size);
            if (VersionUtil.v1_21.isServerVersionHigher()) {
                return;
            }
            ReflectionUtil.setClassField(Material.class, material, "maxStack", size, material.name());
        }
        catch (Throwable t) {
            ConsoleUtil.warning(ChatColor.RED + "Unable to set " + material.name() + " stack size to: " + size);
            t.printStackTrace();
        }
    }

    public static void applyConfiguredStacks() {
        Map<Object, Object> resolvedStacks = new HashMap();
        if (PLUGIN.getConfig().isSet("items")) {
            resolvedStacks = ReflectionUtil.resolveConfiguredItems(PLUGIN.getConfig().getConfigurationSection("items").getKeys(true));
            for (Map.Entry<Object, Object> e : resolvedStacks.entrySet()) {
                Object nmsItem;
                String matName = (String)e.getKey();
                int size = (Integer)e.getValue();
                XMaterial xMat = XMaterial.matchXMaterial(matName).orElse(null);
                if (xMat == null) {
                    ConsoleUtil.warning(ChatColor.RED + "The Item: " + matName + " does not exist. Check MATERIAL_LIST.txt for all up to date item names.");
                    continue;
                }
                Material mat = xMat.get();
                if (mat == null || (nmsItem = ReflectionUtil.hasItemForm(mat)) == null) continue;
                ItemHandler.getInstance().cacheMaterial(xMat, mat.getMaxStackSize());
                ReflectionUtil.applyStackSizeToMaterial(nmsItem, mat, size);
            }
        }
        if (PLUGIN.getConfig().getBoolean("max-stack-for-all-items.enabled")) {
            int stackSize = ReflectionUtil.validateStackSize(PLUGIN.getConfig().getInt("max-stack-for-all-items.amount"), "ALL");
            List configExemptList = PLUGIN.getConfig().getStringList("max-stack-for-all-items.whitelist");
            Set<String> exemptMaterials = configExemptList.stream().filter(Objects::nonNull).map(s -> s.toUpperCase()).collect(Collectors.toSet());
            resolvedStacks.keySet().forEach(name -> {
                boolean bl = exemptMaterials.add(name.toUpperCase());
            });
            ReflectionUtil.updateAllItems(exemptMaterials, stackSize);
        }
    }

    private static Map<String, Integer> resolveConfiguredItems(Collection<String> keys) {
        HashMap<String, Integer> resolved = new HashMap<String, Integer>();
        XMaterial[] allMaterials = XMaterial.VALUES;
        for (String key : keys) {
            Pattern pattern;
            if (key == null || key.isEmpty() || !PLUGIN.getConfig().isInt("items." + key)) continue;
            int stackSize = ReflectionUtil.validateStackSize(PLUGIN.getConfig().getInt("items." + key), key);
            try {
                pattern = Pattern.compile(key, 2);
            }
            catch (PatternSyntaxException ex) {
                ConsoleUtil.warning(ChatColor.RED + "Invalid regex in items: '" + key + "': " + ex.getDescription());
                continue;
            }
            XMaterial[] xMaterialArray = allMaterials;
            int n = allMaterials.length;
            int n2 = 0;
            while (n2 < n) {
                XMaterial material = xMaterialArray[n2];
                String name = material.name();
                if (pattern.matcher(name).matches()) {
                    resolved.putIfAbsent(name.toUpperCase(), stackSize);
                }
                ++n2;
            }
        }
        return resolved;
    }

    private static void updateAllItems(Set<String> exemptMaterials, int stackSize) {
        HashSet<Material> processed = new HashSet<Material>();
        XMaterial[] xMaterialArray = XMaterial.VALUES;
        int n = XMaterial.VALUES.length;
        int n2 = 0;
        while (n2 < n) {
            Object nmsItem;
            Material mat;
            XMaterial xMat = xMaterialArray[n2];
            if (xMat.isSupported() && (mat = xMat.get()) != null && !exemptMaterials.contains(mat.name().toUpperCase()) && !exemptMaterials.contains(xMat.name().toUpperCase()) && processed.add(mat) && (nmsItem = ReflectionUtil.hasItemForm(mat)) != null) {
                ItemHandler.getInstance().cacheMaterial(xMat, mat.getMaxStackSize());
                ReflectionUtil.applyStackSizeToMaterial(nmsItem, mat, stackSize);
            }
            ++n2;
        }
    }

    public static Object hasItemForm(Material mat) {
        try {
            return ReflectionUtil.getNMSItem(mat);
        }
        catch (Throwable t) {
            return null;
        }
    }

    private static Object getNMSItem(Material material) throws Exception {
        Class<?> craftMagicNumbers;
        String cbPkg = Bukkit.getServer().getClass().getPackage().getName();
        String base = cbPkg.startsWith("org.bukkit.craftbukkit") ? cbPkg : "org.bukkit.craftbukkit";
        try {
            craftMagicNumbers = Class.forName(String.valueOf(base) + ".util.CraftMagicNumbers");
        }
        catch (ClassNotFoundException ex) {
            craftMagicNumbers = Class.forName("org.bukkit.craftbukkit.util.CraftMagicNumbers");
        }
        Method getItem = craftMagicNumbers.getMethod("getItem", Material.class);
        return getItem.invoke(null, material);
    }

    private static boolean setClassField(Class<?> clazz, Object instance, String fieldName, int value, String name) {
        try {
            Field field = clazz.getDeclaredField(fieldName);
            field.setAccessible(true);
            field.setInt(instance, value);
            ConsoleUtil.info("Successfully set Bukkit Material " + name + " max stack to: " + value);
            return true;
        }
        catch (Throwable t) {
            ConsoleUtil.warning("Failed to set Bukkit Material max stack of: " + name);
            t.printStackTrace();
            return false;
        }
    }

    private static int validateStackSize(int stackSize, String itemName) {
        int absoluteMaxStackSize = SERVER_VERSION.getAbsoluteMaxStackSize();
        if (stackSize > absoluteMaxStackSize) {
            ConsoleUtil.warning("Stack size: " + stackSize + " can not be set for " + itemName + " item(s) over " + absoluteMaxStackSize + ". Defaulting to max value...");
            return absoluteMaxStackSize;
        }
        if (stackSize < 1) {
            ConsoleUtil.warning(ChatColor.RED + "Unable to set stack size to: " + stackSize + " for " + itemName + " item(s). Defaulting to 1...");
            stackSize = 1;
        }
        return stackSize;
    }
}

