/*
 * Decompiled with CFR 0.152.
 */
package com.codingguru.inventorystacks.util;

import java.util.Objects;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

public class ItemUtil {
    public static boolean addItemToBrewingStand(Inventory inventory, ItemStack item) {
        ItemStack slot1 = inventory.getItem(0);
        ItemStack slot2 = inventory.getItem(1);
        ItemStack slot3 = inventory.getItem(2);
        if (slot1 == null || slot1.getType() == Material.AIR) {
            inventory.setItem(0, item);
            return true;
        }
        if (slot2 == null || slot2.getType() == Material.AIR) {
            inventory.setItem(1, item);
            return true;
        }
        if (slot3 == null || slot3.getType() == Material.AIR) {
            inventory.setItem(2, item);
            return true;
        }
        return false;
    }

    public static boolean removeOneMatching(Inventory inv, ItemStack needle) {
        int i = 0;
        while (i < inv.getSize()) {
            ItemStack s = inv.getItem(i);
            if (s != null && s.getType() != Material.AIR && s.getType() == needle.getType() && Objects.equals(s.getItemMeta(), needle.getItemMeta())) {
                if (s.getAmount() <= 1) {
                    inv.setItem(i, null);
                } else {
                    s.setAmount(s.getAmount() - 1);
                    inv.setItem(i, s);
                }
                return true;
            }
            ++i;
        }
        return false;
    }

    public static void addItem(Player player, ItemStack item) {
        int maxAmount;
        int amount = item.getAmount();
        if (amount > (maxAmount = item.getMaxStackSize())) {
            item.setAmount(maxAmount);
            ItemUtil.add(player, item);
            int i = amount - maxAmount;
            while (i >= maxAmount) {
                ItemUtil.add(player, item);
                i -= maxAmount;
            }
            if (amount % maxAmount > 0) {
                item.setAmount(amount % maxAmount);
                ItemUtil.add(player, item);
            }
        } else {
            ItemUtil.add(player, item);
        }
    }

    private static void add(Player player, ItemStack item) {
        if (player.getInventory().firstEmpty() == -1) {
            player.getWorld().dropItemNaturally(player.getLocation(), item);
        } else {
            player.getInventory().addItem(new ItemStack[]{item});
        }
    }
}

