/*
 * Decompiled with CFR 0.152.
 */
package com.codingguru.inventorystacks.scheduler;

import com.codingguru.inventorystacks.scheduler.Schedule;
import com.codingguru.inventorystacks.util.ItemUtil;
import com.codingguru.inventorystacks.util.VersionUtil;
import java.lang.ref.WeakReference;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class ChangeItemInHandWithItemTask
extends Schedule {
    private final WeakReference<Player> player;
    private final ItemStack item;
    private final ItemStack addedItem;
    private final Material material;

    public ChangeItemInHandWithItemTask(Player player, ItemStack item, ItemStack addedItem, Material material) {
        this.player = new WeakReference<Player>(player);
        this.item = item;
        this.addedItem = addedItem;
        this.material = material;
    }

    @Override
    public void run() {
        Player player = (Player)this.player.get();
        this.updateItem(player, this.item, this.material);
        ItemUtil.addItem(player, this.addedItem);
    }

    private void updateItem(Player player, ItemStack item, Material mat) {
        if (!VersionUtil.v1_9_R1.isServerVersionHigher()) {
            player.getInventory().setItemInHand(item);
            return;
        }
        if (player.getInventory().getItemInMainHand().getType() == mat) {
            player.getInventory().setItemInMainHand(item);
        } else if (player.getInventory().getItemInOffHand().getType() == mat) {
            player.getInventory().setItemInOffHand(item);
        }
    }
}

