/*
 * Decompiled with CFR 0.152.
 */
package com.codingguru.inventorystacks.managers;

import com.codingguru.inventorystacks.util.MessagesUtil;
import java.io.File;
import java.io.IOException;
import java.util.logging.Level;
import org.bukkit.Bukkit;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.Plugin;

public class SettingsManager {
    private FileConfiguration lang;
    private File langFile;

    public void setup(Plugin p) {
        this.setupLang(p);
        this.setValues();
    }

    private void setupLang(Plugin p) {
        this.langFile = new File(p.getDataFolder(), "lang.yml");
        if (!this.langFile.exists()) {
            try {
                this.langFile.createNewFile();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        this.lang = YamlConfiguration.loadConfiguration((File)this.langFile);
    }

    public FileConfiguration getLang() {
        return this.lang;
    }

    private void saveLang() {
        try {
            this.getLang().save(this.langFile);
        }
        catch (IOException ex) {
            Bukkit.getServer().getLogger().log(Level.SEVERE, "Could not save config to " + this.langFile, ex);
        }
    }

    public void setValues() {
        MessagesUtil[] messagesUtilArray = MessagesUtil.values();
        int n = messagesUtilArray.length;
        int n2 = 0;
        while (n2 < n) {
            MessagesUtil lang = messagesUtilArray[n2];
            if (!this.getLang().isSet(lang.getPath())) {
                this.getLang().set(lang.getPath(), (Object)lang.getDefault());
            }
            ++n2;
        }
        this.saveLang();
    }
}

