/*
 * Decompiled with CFR 0.152.
 */
package com.codingguru.inventorystacks.listeners;

import com.codingguru.inventorystacks.handlers.ItemHandler;
import com.codingguru.inventorystacks.util.ItemUtil;
import com.codingguru.inventorystacks.util.MessagesUtil;
import com.codingguru.inventorystacks.util.RandomUtil;
import com.codingguru.inventorystacks.util.XMaterial;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerCommandPreprocessEvent;
import org.bukkit.event.server.ServerCommandEvent;
import org.bukkit.inventory.ItemStack;

public class Commands
implements Listener {
    @EventHandler(priority=EventPriority.LOWEST)
    public void onPlayerCommandPreprocess(PlayerCommandPreprocessEvent e) {
        if (!e.getMessage().startsWith("/give")) {
            return;
        }
        String[] command = e.getMessage().split(" ");
        if (command.length < 4) {
            return;
        }
        String itemName = command[2].replaceAll("minecraft:", "");
        if (command[2] == null || command[3] == null) {
            return;
        }
        int amount = Integer.parseInt(command[3]);
        Optional<XMaterial> item = XMaterial.matchXMaterial(itemName);
        if (item == null || !item.isPresent() || item.get() == null) {
            return;
        }
        XMaterial material = item.get();
        if (!ItemHandler.getInstance().getCachedMaterialSizes().containsKey(material)) {
            return;
        }
        if (this.isDamageable(material.get())) {
            e.setCancelled(true);
            List<Player> targetedPlayers = this.getTargetedPlayers(e.getPlayer(), command[1]);
            if (targetedPlayers.isEmpty()) {
                MessagesUtil.sendMessage((CommandSender)e.getPlayer(), MessagesUtil.PLAYER_NOT_FOUND.toString().replaceAll("%id%", command[1]));
                return;
            }
            itemName = itemName.toLowerCase().replaceAll("_", " ");
            String niceName = String.valueOf(itemName.substring(0, 1).toUpperCase()) + itemName.substring(1);
            ItemStack itemStack = material.parseItem();
            itemStack.setAmount(amount);
            targetedPlayers.stream().forEach(player -> {
                ItemUtil.addItem(player, itemStack);
                MessagesUtil.sendMessage((CommandSender)e.getPlayer(), MessagesUtil.GIVEN_ITEM.toString().replaceAll("%amount%", String.valueOf(amount)).replaceAll("%item%", niceName).replaceAll("%id%", player.getName()));
            });
        }
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onServerCommand(ServerCommandEvent e) {
        if (!e.getCommand().startsWith("give")) {
            return;
        }
        String[] command = e.getCommand().split(" ");
        if (command.length < 4) {
            return;
        }
        String itemName = command[2].replaceAll("minecraft:", "");
        if (command[2] == null || command[3] == null) {
            return;
        }
        int amount = Integer.parseInt(command[3]);
        Optional<XMaterial> item = XMaterial.matchXMaterial(itemName);
        if (item == null || !item.isPresent() || item.get() == null) {
            return;
        }
        XMaterial material = item.get();
        if (!ItemHandler.getInstance().getCachedMaterialSizes().containsKey(material)) {
            return;
        }
        if (this.isDamageable(material.get())) {
            e.setCancelled(true);
            List<Player> targetedPlayers = this.getTargetedPlayers(null, command[1]);
            if (targetedPlayers.isEmpty()) {
                MessagesUtil.sendMessage(e.getSender(), MessagesUtil.PLAYER_NOT_FOUND.toString().replaceAll("%id%", command[1]));
                return;
            }
            itemName = itemName.toLowerCase().replaceAll("_", " ");
            String niceName = String.valueOf(itemName.substring(0, 1).toUpperCase()) + itemName.substring(1);
            ItemStack itemStack = material.parseItem();
            itemStack.setAmount(amount);
            targetedPlayers.stream().forEach(player -> {
                ItemUtil.addItem(player, itemStack);
                MessagesUtil.sendMessage(e.getSender(), MessagesUtil.GIVEN_ITEM.toString().replaceAll("%amount%", String.valueOf(amount)).replaceAll("%item%", niceName).replaceAll("%id%", player.getName()));
            });
        }
    }

    public List<Player> getTargetedPlayers(Player player, String value) {
        switch (value) {
            case "@a": 
            case "@e": {
                return Lists.newArrayList((Iterable)Bukkit.getOnlinePlayers());
            }
            case "@n": 
            case "@p": {
                if (player == null) {
                    return Lists.newArrayList();
                }
                Player nearestPlayer = player.getWorld().getPlayers().stream().filter(p -> !p.equals(player)).min(Comparator.comparingDouble(p -> p.getLocation().distanceSquared(player.getLocation()))).orElse(null);
                if (nearestPlayer == null) {
                    return Lists.newArrayList();
                }
                return Lists.newArrayList((Object[])new Player[]{nearestPlayer});
            }
            case "@s": {
                if (player == null) {
                    return Lists.newArrayList();
                }
                return Lists.newArrayList((Object[])new Player[]{player});
            }
            case "@r": {
                ArrayList players = Lists.newArrayList((Iterable)Bukkit.getOnlinePlayers());
                Player selectedPlayer = (Player)RandomUtil.getRandomItem(players);
                return Lists.newArrayList((Object[])new Player[]{selectedPlayer});
            }
        }
        Player target = Bukkit.getPlayer((String)value);
        if (target == null) {
            return Lists.newArrayList();
        }
        return Lists.newArrayList((Object[])new Player[]{target});
    }

    private boolean isDamageable(Material m) {
        switch (m) {
            case BOW: 
            case CARROT_ON_A_STICK: 
            case CHAINMAIL_BOOTS: 
            case CHAINMAIL_CHESTPLATE: 
            case CHAINMAIL_HELMET: 
            case CHAINMAIL_LEGGINGS: 
            case CROSSBOW: 
            case DIAMOND_AXE: 
            case DIAMOND_BOOTS: 
            case DIAMOND_CHESTPLATE: 
            case DIAMOND_HELMET: 
            case DIAMOND_HOE: 
            case DIAMOND_LEGGINGS: 
            case DIAMOND_PICKAXE: 
            case DIAMOND_SHOVEL: 
            case DIAMOND_SWORD: 
            case ELYTRA: 
            case FISHING_ROD: 
            case FLINT_AND_STEEL: 
            case GOLDEN_AXE: 
            case GOLDEN_BOOTS: 
            case GOLDEN_CHESTPLATE: 
            case GOLDEN_HELMET: 
            case GOLDEN_HOE: 
            case GOLDEN_LEGGINGS: 
            case GOLDEN_PICKAXE: 
            case GOLDEN_SHOVEL: 
            case GOLDEN_SWORD: 
            case IRON_AXE: 
            case IRON_BOOTS: 
            case IRON_CHESTPLATE: 
            case IRON_HELMET: 
            case IRON_HOE: 
            case IRON_LEGGINGS: 
            case IRON_PICKAXE: 
            case IRON_SHOVEL: 
            case IRON_SWORD: 
            case LEATHER_BOOTS: 
            case LEATHER_CHESTPLATE: 
            case LEATHER_HELMET: 
            case LEATHER_LEGGINGS: 
            case NETHERITE_AXE: 
            case NETHERITE_BOOTS: 
            case NETHERITE_CHESTPLATE: 
            case NETHERITE_HELMET: 
            case NETHERITE_HOE: 
            case NETHERITE_LEGGINGS: 
            case NETHERITE_PICKAXE: 
            case NETHERITE_SHOVEL: 
            case NETHERITE_SWORD: 
            case SHEARS: 
            case SHIELD: 
            case STONE_AXE: 
            case STONE_HOE: 
            case STONE_PICKAXE: 
            case STONE_SHOVEL: 
            case STONE_SWORD: 
            case TRIDENT: 
            case TURTLE_HELMET: 
            case WARPED_FUNGUS_ON_A_STICK: 
            case WOODEN_AXE: 
            case WOODEN_HOE: 
            case WOODEN_PICKAXE: 
            case WOODEN_SHOVEL: 
            case WOODEN_SWORD: {
                return true;
            }
        }
        return false;
    }
}

