/*
 * Decompiled with CFR 0.152.
 */
package com.codingguru.inventorystacks.handlers;

import com.codingguru.inventorystacks.InventoryStacks;
import com.codingguru.inventorystacks.util.ConsoleUtil;
import com.codingguru.inventorystacks.util.ReflectionUtil;
import com.codingguru.inventorystacks.util.ServerTypeUtil;
import com.codingguru.inventorystacks.util.VersionUtil;
import com.codingguru.inventorystacks.util.XMaterial;
import com.google.common.collect.Maps;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.plugin.Plugin;

public class ItemHandler {
    private static final ItemHandler INSTANCE = new ItemHandler();
    private final Map<XMaterial, Integer> cachedMaterials = Maps.newHashMap();
    private VersionUtil serverVersion;
    private ServerTypeUtil serverType;
    private Field legacyMaxStackField;
    private Object maxStackComponentKey;
    private Method itemComponentsAccessor;
    private Field itemComponentsField;
    private Method builderFactory;
    private Method builderAddAll;
    private Method builderSet;
    private Method builderBuild;

    private ItemHandler() {
    }

    public static ItemHandler getInstance() {
        return INSTANCE;
    }

    public void setup() {
        if (!this.setupServerVersion()) {
            String pkg = Bukkit.getServer().getClass().getPackage().getName();
            String versionFound = pkg.substring(pkg.lastIndexOf(46) + 1);
            ConsoleUtil.warning("THE VERSION: " + versionFound + " IS CURRENTLY UNSUPPORTED. DISABLING PLUGIN...");
            Bukkit.getPluginManager().disablePlugin((Plugin)InventoryStacks.getInstance());
            return;
        }
        this.setupServerType();
        this.setupReflection();
    }

    public boolean setupServerVersion() {
        String pkg = Bukkit.getServer().getClass().getPackage().getName();
        String versionFound = pkg.substring(pkg.lastIndexOf(46) + 1);
        String cleanVersion = Bukkit.getBukkitVersion().split("-")[0];
        String[] parts = cleanVersion.split("\\.");
        if (parts.length < 2) {
            return false;
        }
        String majorMinor = String.valueOf(parts[0]) + "." + parts[1];
        if (versionFound.equalsIgnoreCase("craftbukkit")) {
            if (majorMinor.equals("1.21")) {
                this.serverVersion = VersionUtil.v1_21;
                return true;
            }
            if (majorMinor.equals("1.20")) {
                this.serverVersion = VersionUtil.v1_20;
                return true;
            }
            return false;
        }
        VersionUtil[] versionUtilArray = VersionUtil.values();
        int n = versionUtilArray.length;
        int n2 = 0;
        while (n2 < n) {
            VersionUtil version = versionUtilArray[n2];
            if (versionFound.contains(version.name())) {
                this.serverVersion = version;
                return true;
            }
            ++n2;
        }
        return false;
    }

    private void setupServerType() {
        try {
            Class.forName("io.papermc.paper.threadedregions.RegionizedServer");
            this.serverType = ServerTypeUtil.FOLIA;
            return;
        }
        catch (ClassNotFoundException classNotFoundException) {
            try {
                Class.forName("io.papermc.paper.ServerBuildInfo");
                this.serverType = ServerTypeUtil.PAPER;
                return;
            }
            catch (ClassNotFoundException classNotFoundException2) {
                this.serverType = ServerTypeUtil.SPIGOT;
                return;
            }
        }
    }

    private void setupReflection() {
        try {
            Field maxStackField;
            Class<?> itemClass = Class.forName(this.serverVersion.getItemClass());
            if (!this.serverVersion.usesDataComponents()) {
                this.legacyMaxStackField = itemClass.getDeclaredField(this.serverVersion.getLegacyStackField());
                this.legacyMaxStackField.setAccessible(true);
                return;
            }
            Class<?> dataComponents = Class.forName("net.minecraft.core.component.DataComponents");
            try {
                maxStackField = dataComponents.getField("MAX_STACK_SIZE");
            }
            catch (NoSuchFieldException e) {
                maxStackField = dataComponents.getField("c");
            }
            this.maxStackComponentKey = maxStackField.get(null);
            this.itemComponentsAccessor = itemClass.getDeclaredMethod("f", new Class[0]);
            this.itemComponentsAccessor.setAccessible(true);
            this.itemComponentsField = itemClass.getDeclaredField("c");
            this.itemComponentsField.setAccessible(true);
            Class<?> dataComponentMapClass = Class.forName("net.minecraft.core.component.DataComponentMap");
            Class<?> builderClass = Class.forName("net.minecraft.core.component.DataComponentMap$a");
            this.builderFactory = dataComponentMapClass.getDeclaredMethod("a", new Class[0]);
            this.builderFactory.setAccessible(true);
            this.builderAddAll = builderClass.getDeclaredMethod("a", dataComponentMapClass);
            this.builderAddAll.setAccessible(true);
            Class<?> keyType = Class.forName("net.minecraft.core.component.DataComponentType");
            this.builderSet = builderClass.getDeclaredMethod("a", keyType, Object.class);
            this.builderSet.setAccessible(true);
            this.builderBuild = builderClass.getDeclaredMethod("a", new Class[0]);
            this.builderBuild.setAccessible(true);
        }
        catch (Throwable t) {
            ConsoleUtil.warning(ChatColor.RED + "Unable to setup reflection values. Disabling plugin...");
            t.printStackTrace();
            Bukkit.getPluginManager().disablePlugin((Plugin)InventoryStacks.getInstance());
        }
    }

    public void applyStackSizeToNmsItem(Object nmsItem, int size) {
        try {
            if (!this.serverVersion.usesDataComponents()) {
                this.legacyMaxStackField.setInt(nmsItem, size);
                return;
            }
            Object currentMap = this.itemComponentsAccessor.invoke(nmsItem, new Object[0]);
            Object builder = this.builderFactory.invoke(null, new Object[0]);
            this.builderAddAll.invoke(builder, currentMap);
            this.builderSet.invoke(builder, this.maxStackComponentKey, size);
            Object newMap = this.builderBuild.invoke(builder, new Object[0]);
            this.itemComponentsField.set(nmsItem, newMap);
        }
        catch (Throwable t) {
            ConsoleUtil.warning(ChatColor.RED + "Unable to set " + nmsItem.toString() + " stack size to: " + size);
            t.printStackTrace();
        }
    }

    public void cacheMaterial(XMaterial mat, int defaultSize) {
        this.cachedMaterials.putIfAbsent(mat, defaultSize);
    }

    public Map<XMaterial, Integer> getCachedMaterialSizes() {
        return this.cachedMaterials;
    }

    public void reloadInventoryStacks() {
        this.resetMaterialsToDefaultValues();
        this.cachedMaterials.clear();
        ReflectionUtil.applyConfiguredStacks();
    }

    private void resetMaterialsToDefaultValues() {
        for (Map.Entry<XMaterial, Integer> entry : this.cachedMaterials.entrySet()) {
            Material mat = entry.getKey().get();
            Object nmsItem = ReflectionUtil.hasItemForm(mat);
            if (nmsItem == null) continue;
            int defaultSize = entry.getValue();
            ReflectionUtil.applyStackSizeToMaterial(nmsItem, mat, defaultSize);
        }
    }

    public VersionUtil getServerVersion() {
        return this.serverVersion;
    }

    public ServerTypeUtil getServerType() {
        return this.serverType;
    }
}

