/*
 * Decompiled with CFR 0.152.
 */
package com.codingguru.autofish.handlers;

import com.codingguru.autofish.data.PlayerFishingData;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Location;

public class PlayerHandler {
    private static final PlayerHandler INSTANCE = new PlayerHandler();
    private Map<UUID, PlayerFishingData> cachedData = new HashMap<UUID, PlayerFishingData>();

    public PlayerFishingData getFishingData(UUID uuid, Location location) {
        if (this.cachedData.containsKey(uuid)) {
            return this.cachedData.get(uuid);
        }
        return new PlayerFishingData(uuid, location);
    }

    public boolean hasFishingData(UUID uuid) {
        return this.cachedData.containsKey(uuid);
    }

    public void addFishingData(UUID uuid, PlayerFishingData data) {
        this.cachedData.put(uuid, data);
    }

    public void removeFishingData(UUID uuid) {
        this.cachedData.remove(uuid);
    }

    public static PlayerHandler getInstance() {
        return INSTANCE;
    }
}

