/*
 * Decompiled with CFR 0.152.
 */
package com.codingguru.autofish.data;

import com.codingguru.autofish.AntiAutoFish;
import com.codingguru.autofish.handlers.PlayerHandler;
import com.codingguru.autofish.util.ColorUtil;
import java.util.UUID;
import org.bukkit.Location;
import org.bukkit.entity.Player;

public class PlayerFishingData {
    private UUID uuid;
    private Location location;
    private long nextUse;
    private int exploitNumber;

    public PlayerFishingData(UUID uuid, Location location) {
        this.uuid = uuid;
        this.location = location;
        PlayerHandler.getInstance().addFishingData(uuid, this);
    }

    public boolean isFishCancelled(Player player) {
        if (this.nextUse != 0L && System.currentTimeMillis() < this.nextUse) {
            return true;
        }
        if (!this.getLocation().getWorld().getName().equalsIgnoreCase(player.getLocation().getWorld().getName())) {
            PlayerHandler.getInstance().removeFishingData(player.getUniqueId());
            return false;
        }
        if (AntiAutoFish.getInstance().getConfig().getBoolean("max-fish-distance.enabled") && this.getLocation().distance(player.getLocation()) > (double)AntiAutoFish.getInstance().getConfig().getInt("max-fish-distance.distance")) {
            PlayerHandler.getInstance().removeFishingData(player.getUniqueId());
            return false;
        }
        if (!this.getLocation().equals((Object)player.getLocation())) {
            PlayerHandler.getInstance().removeFishingData(player.getUniqueId());
            return false;
        }
        this.setExploitNumber(this.getExploitNumber() + 1);
        if (AntiAutoFish.getInstance().getConfig().getBoolean("fishing-cooldown.enabled") && AntiAutoFish.getInstance().getConfig().getIntegerList("fishing-cooldown.exploit-numbers").contains(this.getExploitNumber())) {
            long total = 1000 * AntiAutoFish.getInstance().getConfig().getInt("fishing-cooldown.length");
            this.setNextUse(System.currentTimeMillis() + total);
        }
        if (AntiAutoFish.getInstance().getConfig().getBoolean("fishing-messages.enabled") && AntiAutoFish.getInstance().getConfig().getIntegerList("fishing-messages.exploit-numbers").contains(this.getExploitNumber())) {
            player.sendMessage(ColorUtil.replace(AntiAutoFish.getInstance().getConfig().getString("fishing-messages.message")));
        }
        if (AntiAutoFish.getInstance().getConfig().getBoolean("disallow-fish.enabled") && AntiAutoFish.getInstance().getConfig().getIntegerList("disallow-fish.exploit-numbers").contains(this.getExploitNumber())) {
            return true;
        }
        if (AntiAutoFish.getInstance().getConfig().getBoolean("kicking-players.enabled") && AntiAutoFish.getInstance().getConfig().getIntegerList("kicking-players.exploit-numbers").contains(this.getExploitNumber())) {
            player.kickPlayer(ColorUtil.replace(AntiAutoFish.getInstance().getConfig().getString("kicking-players.message")));
            return false;
        }
        return false;
    }

    public void setExploitNumber(int exploitNumber) {
        this.exploitNumber = exploitNumber;
    }

    public int getExploitNumber() {
        return this.exploitNumber;
    }

    public void setNextUse(long nextUse) {
        this.nextUse = nextUse;
    }

    public long getNextUse() {
        return this.nextUse;
    }

    public UUID getUUID() {
        return this.uuid;
    }

    public Location getLocation() {
        return this.location;
    }
}

