/*
 * Decompiled with CFR 0.152.
 */
package nl.chimpgamer.ultimatemobcoins.paper.utils;

import java.util.Collection;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.random.Random;
import nl.chimpgamer.ultimatemobcoins.paper.extensions.ExPersistentDataHolderKt;
import org.bukkit.Color;
import org.bukkit.FireworkEffect;
import org.bukkit.Location;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Firework;
import org.bukkit.inventory.meta.FireworkMeta;
import org.bukkit.persistence.PersistentDataHolder;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u000e\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001c\u0010\b\u001a\u0010\u0012\f\u0012\n \u000b*\u0004\u0018\u00010\n0\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\u00020\r8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0016"}, d2={"Lnl/chimpgamer/ultimatemobcoins/paper/utils/FireworkUtil;", "", "<init>", "()V", "noDamageKey", "Lorg/bukkit/NamespacedKey;", "getNoDamageKey", "()Lorg/bukkit/NamespacedKey;", "colors", "", "Lorg/bukkit/Color;", "kotlin.jvm.PlatformType", "randomEffect", "Lorg/bukkit/FireworkEffect;", "getRandomEffect", "()Lorg/bukkit/FireworkEffect;", "type", "Lorg/bukkit/FireworkEffect$Type;", "shootRandomFirework", "", "location", "Lorg/bukkit/Location;", "paper"})
public final class FireworkUtil {
    @NotNull
    public static final FireworkUtil INSTANCE = new FireworkUtil();
    @NotNull
    private static final NamespacedKey noDamageKey = new NamespacedKey("ultimatemobcoins", "no_firework_damage");
    @NotNull
    private static final Set<Color> colors;

    private FireworkUtil() {
    }

    @NotNull
    public final NamespacedKey getNoDamageKey() {
        return noDamageKey;
    }

    private final FireworkEffect getRandomEffect() {
        return this.getRandomEffect((FireworkEffect.Type)CollectionsKt.random((Collection)((Collection)EntriesMappings.entries$0), (Random)((Random)Random.Default)));
    }

    private final FireworkEffect getRandomEffect(FireworkEffect.Type type) {
        FireworkEffect fireworkEffect = FireworkEffect.builder().flicker(Random.Default.nextBoolean()).withColor((Color)CollectionsKt.random((Collection)colors, (Random)((Random)Random.Default))).withFade((Color)CollectionsKt.random((Collection)colors, (Random)((Random)Random.Default))).with(type).trail(Random.Default.nextBoolean()).build();
        Intrinsics.checkNotNullExpressionValue((Object)fireworkEffect, (String)"build(...)");
        return fireworkEffect;
    }

    public final void shootRandomFirework(@NotNull Location location) {
        FireworkMeta fireworkMeta;
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        Entity entity = location.getWorld().spawn(location, Firework.class);
        Intrinsics.checkNotNullExpressionValue((Object)entity, (String)"spawn(...)");
        Firework firework = (Firework)entity;
        ExPersistentDataHolderKt.setBoolean(ExPersistentDataHolderKt.getPdc((PersistentDataHolder)firework), noDamageKey, true);
        FireworkMeta $this$shootRandomFirework_u24lambda_u240 = fireworkMeta = firework.getFireworkMeta();
        boolean bl = false;
        $this$shootRandomFirework_u24lambda_u240.addEffect(INSTANCE.getRandomEffect());
        FireworkMeta fireworkMeta2 = fireworkMeta;
        Intrinsics.checkNotNullExpressionValue((Object)fireworkMeta2, (String)"apply(...)");
        FireworkMeta fireworkMeta3 = fireworkMeta2;
        firework.setFireworkMeta(fireworkMeta3);
    }

    static {
        Object[] objectArray = new Color[]{Color.AQUA, Color.BLUE, Color.BLACK, Color.GRAY, Color.FUCHSIA, Color.GREEN, Color.LIME, Color.MAROON, Color.NAVY, Color.OLIVE, Color.ORANGE, Color.PURPLE, Color.RED, Color.SILVER, Color.TEAL, Color.WHITE, Color.YELLOW};
        colors = SetsKt.setOf((Object[])objectArray);
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class EntriesMappings {
        public static final /* synthetic */ EnumEntries<FireworkEffect.Type> entries$0;

        static {
            entries$0 = EnumEntriesKt.enumEntries((Enum[])((Enum[])FireworkEffect.Type.values()));
        }
    }
}

