/*
 * Decompiled with CFR 0.152.
 */
package nl.chimpgamer.ultimatemobcoins.paper.models.menu;

import dev.dejvokep.boostedyaml.YamlDocument;
import dev.dejvokep.boostedyaml.block.implementation.Section;
import dev.dejvokep.boostedyaml.settings.Settings;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.time.Duration;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.UUID;
import java.util.logging.Level;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import nl.chimpgamer.ultimatemobcoins.paper.UltimateMobCoinsPlugin;
import nl.chimpgamer.ultimatemobcoins.paper.configurations.MenuConfig;
import nl.chimpgamer.ultimatemobcoins.paper.models.menu.Menu;
import nl.chimpgamer.ultimatemobcoins.paper.models.menu.MenuItem;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001f\n\u0000\b&\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0006\u0010\u000e\u001a\u00020\u000fJ\u0006\u0010\u0010\u001a\u00020\u000fJ\u0006\u0010\u0011\u001a\u00020\u0012J\u0006\u0010\u0013\u001a\u00020\u0014J\b\u0010\u0015\u001a\u00020\u0014H&J\b\u0010\u0016\u001a\u00020\u0014H&J\b\u0010\u0017\u001a\u00020\u0014H&J\u0014\u0010\u0017\u001a\u00020\u00142\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0019J\u0016\u0010\u001b\u001a\u00020\u000f2\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u001cH\u0004R\u001a\u0010\b\u001a\u00020\tX\u0084.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\r\u00a8\u0006\u001d"}, d2={"Lnl/chimpgamer/ultimatemobcoins/paper/models/menu/RefreshableShopMenu;", "Lnl/chimpgamer/ultimatemobcoins/paper/models/menu/Menu;", "plugin", "Lnl/chimpgamer/ultimatemobcoins/paper/UltimateMobCoinsPlugin;", "config", "Lnl/chimpgamer/ultimatemobcoins/paper/configurations/MenuConfig;", "<init>", "(Lnl/chimpgamer/ultimatemobcoins/paper/UltimateMobCoinsPlugin;Lnl/chimpgamer/ultimatemobcoins/paper/configurations/MenuConfig;)V", "refreshTime", "Ljava/time/Instant;", "getRefreshTime", "()Ljava/time/Instant;", "setRefreshTime", "(Ljava/time/Instant;)V", "hasResetTimer", "", "timeToRefresh", "getTimeRemaining", "Ljava/time/Duration;", "resetTimeRemaining", "", "refresh", "refreshShopItems", "saveShopItemsData", "items", "", "Lnl/chimpgamer/ultimatemobcoins/paper/models/menu/MenuItem;", "getItemsFromLastShopData", "", "paper"})
@SourceDebugExtension(value={"SMAP\nRefreshableShopMenu.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RefreshableShopMenu.kt\nnl/chimpgamer/ultimatemobcoins/paper/models/menu/RefreshableShopMenu\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,125:1\n1869#2:126\n1870#2:128\n1193#2,2:130\n1267#2,4:132\n1#3:127\n216#4:129\n217#4:136\n*S KotlinDebug\n*F\n+ 1 RefreshableShopMenu.kt\nnl/chimpgamer/ultimatemobcoins/paper/models/menu/RefreshableShopMenu\n*L\n64#1:126\n64#1:128\n104#1:130,2\n104#1:132,4\n98#1:129\n98#1:136\n*E\n"})
public abstract class RefreshableShopMenu
extends Menu {
    protected Instant refreshTime;

    public RefreshableShopMenu(@NotNull UltimateMobCoinsPlugin plugin, @NotNull MenuConfig config) {
        Intrinsics.checkNotNullParameter((Object)plugin, (String)"plugin");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        super(plugin, config);
        this.resetTimeRemaining();
    }

    @NotNull
    protected final Instant getRefreshTime() {
        Instant instant = this.refreshTime;
        if (instant != null) {
            return instant;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"refreshTime");
        return null;
    }

    protected final void setRefreshTime(@NotNull Instant instant) {
        Intrinsics.checkNotNullParameter((Object)instant, (String)"<set-?>");
        this.refreshTime = instant;
    }

    public final boolean hasResetTimer() {
        return this.refreshTime != null;
    }

    public final boolean timeToRefresh() {
        return this.hasResetTimer() && Instant.now().isAfter(this.getRefreshTime());
    }

    @NotNull
    public final Duration getTimeRemaining() {
        Duration duration;
        Instant now = Instant.now();
        if (now.isBefore(this.getRefreshTime())) {
            Duration duration2 = Duration.between(now, this.getRefreshTime());
            Intrinsics.checkNotNull((Object)duration2);
            duration = duration2;
        } else {
            Duration duration3 = Duration.ZERO;
            Intrinsics.checkNotNull((Object)duration3);
            duration = duration3;
        }
        return duration;
    }

    public final void resetTimeRemaining() {
        Long refreshTime = this.getConfig().getLong("refresh_time");
        if (refreshTime == null || refreshTime <= 0L) {
            return;
        }
        Instant instant = Instant.now().plusSeconds(refreshTime);
        Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"plusSeconds(...)");
        this.setRefreshTime(instant);
    }

    public abstract void refresh();

    public abstract void refreshShopItems();

    public abstract void saveShopItemsData();

    public final void saveShopItemsData(@NotNull Collection<MenuItem> items) {
        Intrinsics.checkNotNullParameter(items, (String)"items");
        if (items.isEmpty()) {
            return;
        }
        if (!this.hasResetTimer()) {
            return;
        }
        Path shopDataFolder = this.getPlugin().getDataFolder().toPath().resolve("data");
        Intrinsics.checkNotNull((Object)shopDataFolder);
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (!Files.isDirectory(shopDataFolder, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            FileAttribute[] fileAttributeArray = new FileAttribute[]{};
            Intrinsics.checkNotNullExpressionValue((Object)Files.createDirectory(shopDataFolder, Arrays.copyOf(fileAttributeArray, fileAttributeArray.length)), (String)"createDirectory(...)");
        }
        Path shopDataFile = shopDataFolder.resolve(FilesKt.getNameWithoutExtension((File)this.getFile()) + "-data.yml");
        Intrinsics.checkNotNull((Object)shopDataFile);
        LinkOption[] linkOptionArray2 = new LinkOption[]{};
        if (Files.notExists(shopDataFile, Arrays.copyOf(linkOptionArray2, linkOptionArray2.length))) {
            FileAttribute[] fileAttributeArray = new FileAttribute[]{};
            Intrinsics.checkNotNullExpressionValue((Object)Files.createFile(shopDataFile, Arrays.copyOf(fileAttributeArray, fileAttributeArray.length)), (String)"createFile(...)");
        }
        try {
            YamlDocument config = YamlDocument.create((File)shopDataFile.toFile(), (Settings[])new Settings[0]);
            config.set("refresh-time", (Object)this.getRefreshTime().toEpochMilli());
            Section itemsDataSection = config.createSection("items-data");
            itemsDataSection.clear();
            Iterable $this$forEach$iv = items;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                MenuItem shopItem = (MenuItem)element$iv;
                boolean bl = false;
                Integer n = shopItem.getStock();
                if (n != null) {
                    int it = ((Number)n).intValue();
                    boolean bl2 = false;
                    itemsDataSection.set(shopItem.getName() + ".stock", (Object)it);
                }
                itemsDataSection.set(shopItem.getName() + ".purchase-limits", shopItem.getPurchaseLimits());
                itemsDataSection.set(shopItem.getName() + ".position", (Object)shopItem.getPosition());
            }
            config.save();
        }
        catch (IOException iOException) {
            this.getPlugin().getLogger().log(Level.SEVERE, "Something went wrong trying to create data file for shop " + this.getFile().getName());
        }
    }

    /*
     * WARNING - void declaration
     */
    protected final boolean getItemsFromLastShopData(@NotNull Collection<MenuItem> items) {
        Intrinsics.checkNotNullParameter(items, (String)"items");
        if (!items.isEmpty()) {
            return false;
        }
        Path shopDataFolder = this.getPlugin().getDataFolder().toPath().resolve("data");
        Intrinsics.checkNotNull((Object)shopDataFolder);
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (!Files.isDirectory(shopDataFolder, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            return false;
        }
        Path shopDataFile = shopDataFolder.resolve(FilesKt.getNameWithoutExtension((File)this.getFile()) + "-data.yml");
        Intrinsics.checkNotNull((Object)shopDataFile);
        LinkOption[] linkOptionArray2 = new LinkOption[]{};
        if (Files.notExists(shopDataFile, Arrays.copyOf(linkOptionArray2, linkOptionArray2.length))) {
            return false;
        }
        try {
            YamlDocument config = YamlDocument.create((File)shopDataFile.toFile(), (Settings[])new Settings[0]);
            Long l = config.getLong("refresh-time");
            Intrinsics.checkNotNullExpressionValue((Object)l, (String)"getLong(...)");
            Instant refreshTime = Instant.ofEpochMilli(((Number)l).longValue());
            if (refreshTime.isBefore(Instant.now())) {
                return false;
            }
            Intrinsics.checkNotNull((Object)refreshTime);
            this.setRefreshTime(refreshTime);
            Section itemsDataSection = config.getSection("items-data");
            if (itemsDataSection.isEmpty(false)) {
                return false;
            }
            items.clear();
            Map map2 = itemsDataSection.getStringRouteMappedValues(false);
            Intrinsics.checkNotNullExpressionValue((Object)map2, (String)"getStringRouteMappedValues(...)");
            Map $this$forEach$iv = map2;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry element$iv;
                Map.Entry entry = element$iv = iterator.next();
                boolean bl = false;
                String itemName = (String)entry.getKey();
                Object section = entry.getValue();
                Intrinsics.checkNotNull((Object)itemName);
                MenuItem menuItem = this.getItem(itemName);
                if (menuItem == null || (menuItem = menuItem.clone()) == null) continue;
                MenuItem item = menuItem;
                if (section instanceof Section) {
                    void $this$associateTo$iv$iv;
                    void $this$associate$iv;
                    Integer stock = ((Section)section).getInt("stock", null);
                    Section section2 = ((Section)section).getSection("purchase-limits");
                    if (section2 == null) {
                        section2 = ((Section)section).getSection("purchaseLimits");
                    }
                    Iterable iterable = section2.getStringRouteMappedValues(false).entrySet();
                    boolean $i$f$associate = false;
                    int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
                    void var20_21 = $this$associate$iv;
                    Map destination$iv$iv = new LinkedHashMap(capacity$iv);
                    boolean $i$f$associateTo = false;
                    for (Object element$iv$iv : $this$associateTo$iv$iv) {
                        Map map3 = destination$iv$iv;
                        Map.Entry it = (Map.Entry)element$iv$iv;
                        boolean bl2 = false;
                        UUID uUID = UUID.fromString((String)it.getKey());
                        Object v = it.getValue();
                        Intrinsics.checkNotNull(v, (String)"null cannot be cast to non-null type kotlin.Int");
                        Pair pair = TuplesKt.to((Object)uUID, (Object)((Integer)v));
                        map3.put(pair.getFirst(), pair.getSecond());
                    }
                    Map purchaseLimits = MapsKt.toMutableMap((Map)destination$iv$iv);
                    Integer position = ((Section)section).getInt("position");
                    item.setStock(stock);
                    item.setPurchaseLimits(purchaseLimits);
                    Intrinsics.checkNotNull((Object)position);
                    item.setPosition(position);
                }
                items.add(item);
            }
            this.getPlugin().getLogger().info("Loaded " + items.size() + " items from " + shopDataFile.getFileName());
            return true;
        }
        catch (IOException ex) {
            this.getPlugin().getLogger().log(Level.SEVERE, "Something went wrong trying to create data file for shop " + this.getFile().getName(), ex);
            return false;
        }
    }
}

