/*
 * Decompiled with CFR 0.152.
 */
package nl.chimpgamer.ultimatemobcoins.paper.models;

import java.math.BigDecimal;
import java.math.MathContext;
import java.util.Arrays;
import java.util.Objects;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.random.Random;
import nl.chimpgamer.ultimatemobcoins.paper.UltimateMobCoinsPlugin;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u0013\n\u0002\b\r\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u000e\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019J\b\u0010\u001a\u001a\u00020\u001bH\u0002J\u000e\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0018\u001a\u00020\u0019J\u0013\u0010\u001e\u001a\u00020\u001b2\b\u0010\u001f\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010 \u001a\u00020!H\u0016J\b\u0010\"\u001a\u00020\u0005H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0012\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u000f\"\u0004\b\u0014\u0010\u0015\u00a8\u0006#"}, d2={"Lnl/chimpgamer/ultimatemobcoins/paper/models/MobCoin;", "", "plugin", "Lnl/chimpgamer/ultimatemobcoins/paper/UltimateMobCoinsPlugin;", "entityType", "", "chance", "", "amount", "", "<init>", "(Lnl/chimpgamer/ultimatemobcoins/paper/UltimateMobCoinsPlugin;Ljava/lang/String;D[D)V", "getEntityType", "()Ljava/lang/String;", "getChance", "()D", "getAmount", "()[D", "dropChance", "getDropChance", "setDropChance", "(D)V", "applyDropChanceMultiplier", "", "player", "Lorg/bukkit/entity/Player;", "willDropCoins", "", "getAmountToDrop", "Ljava/math/BigDecimal;", "equals", "other", "hashCode", "", "toString", "paper"})
public final class MobCoin {
    @NotNull
    private final UltimateMobCoinsPlugin plugin;
    @NotNull
    private final String entityType;
    private final double chance;
    @NotNull
    private final double[] amount;
    private double dropChance;

    public MobCoin(@NotNull UltimateMobCoinsPlugin plugin, @NotNull String entityType, double chance, @NotNull double[] amount) {
        Intrinsics.checkNotNullParameter((Object)plugin, (String)"plugin");
        Intrinsics.checkNotNullParameter((Object)entityType, (String)"entityType");
        Intrinsics.checkNotNullParameter((Object)amount, (String)"amount");
        this.plugin = plugin;
        this.entityType = entityType;
        this.chance = chance;
        this.amount = amount;
        this.dropChance = this.chance;
    }

    @NotNull
    public final String getEntityType() {
        return this.entityType;
    }

    public final double getChance() {
        return this.chance;
    }

    @NotNull
    public final double[] getAmount() {
        return this.amount;
    }

    public final double getDropChance() {
        return this.dropChance;
    }

    public final void setDropChance(double d) {
        this.dropChance = d;
    }

    public final void applyDropChanceMultiplier(@NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        this.dropChance = this.plugin.applyDropChanceMultiplier(player, this.chance);
    }

    private final boolean willDropCoins() {
        if (this.dropChance >= 100.0) {
            return true;
        }
        return Random.Default.nextDouble(101.0) < this.dropChance;
    }

    @NotNull
    public final BigDecimal getAmountToDrop(@NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        if (this.amount.length == 0) {
            BigDecimal bigDecimal = BigDecimal.ZERO;
            Intrinsics.checkNotNullExpressionValue((Object)bigDecimal, (String)"ZERO");
            return bigDecimal;
        }
        if (!this.willDropCoins()) {
            BigDecimal bigDecimal = BigDecimal.ZERO;
            Intrinsics.checkNotNullExpressionValue((Object)bigDecimal, (String)"ZERO");
            return bigDecimal;
        }
        Enchantment lootingEnchantment = Enchantment.LOOTING;
        ItemStack itemStack = player.getInventory().getItemInMainHand();
        Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"getItemInMainHand(...)");
        ItemStack hand = itemStack;
        if (this.amount[1] == 0.0) {
            double amountOfCoins = this.amount[0];
            if (this.plugin.getSettingsConfig().getMobCoinsLootingEnchantMultiplier() && hand.containsEnchantment(lootingEnchantment)) {
                int level = hand.getEnchantmentLevel(lootingEnchantment);
                int finalLevel = level * 10;
                amountOfCoins += amountOfCoins * (double)finalLevel / (double)100;
            }
            return new BigDecimal(String.valueOf(amountOfCoins));
        }
        double minimumCoins = this.amount[0];
        double maximumCoins = this.amount[1];
        if (this.plugin.getSettingsConfig().getMobCoinsLootingEnchantMultiplier() && hand.containsEnchantment(lootingEnchantment)) {
            int level = hand.getEnchantmentLevel(lootingEnchantment);
            int finalLevel = level * 10;
            minimumCoins += minimumCoins * (double)finalLevel / (double)100;
            maximumCoins += maximumCoins * (double)finalLevel / (double)100;
        }
        return new BigDecimal(Random.Default.nextDouble(maximumCoins - minimumCoins) + minimumCoins, new MathContext(3));
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof MobCoin)) {
            return false;
        }
        return this.entityType == ((MobCoin)other).entityType && this.chance == ((MobCoin)other).chance && Arrays.equals(this.amount, ((MobCoin)other).amount);
    }

    public int hashCode() {
        Object[] objectArray = new Object[]{this.entityType, this.chance, this.amount};
        return Objects.hash(objectArray);
    }

    @NotNull
    public String toString() {
        return "MobCoin(entityType=" + this.entityType + ", chance=" + this.chance + ", amount=" + ArraysKt.joinToString$default((double[])this.amount, null, null, null, (int)0, null, null, (int)63, null) + ")";
    }
}

