/*
 * Decompiled with CFR 0.152.
 */
package nl.chimpgamer.ultimatemobcoins.paper.managers;

import dev.dejvokep.boostedyaml.YamlDocument;
import dev.dejvokep.boostedyaml.block.implementation.Section;
import dev.dejvokep.boostedyaml.settings.Settings;
import dev.dejvokep.boostedyaml.settings.dumper.DumperSettings;
import dev.dejvokep.boostedyaml.settings.general.GeneralSettings;
import dev.dejvokep.boostedyaml.settings.loader.LoaderSettings;
import dev.dejvokep.boostedyaml.settings.updater.UpdaterSettings;
import java.io.File;
import java.io.InputStream;
import java.math.BigDecimal;
import java.math.MathContext;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import nl.chimpgamer.ultimatemobcoins.paper.UltimateMobCoinsPlugin;
import nl.chimpgamer.ultimatemobcoins.paper.configurations.SettingsConfig;
import nl.chimpgamer.ultimatemobcoins.paper.extensions.ExPersistentDataHolderKt;
import nl.chimpgamer.ultimatemobcoins.paper.models.MobCoin;
import nl.chimpgamer.ultimatemobcoins.paper.utils.NamespacedKeys;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataHolder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0001$B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0016\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0014J\u0006\u0010\u0018\u001a\u00020\u0019J\u0010\u0010\u001a\u001a\u0004\u0018\u00010\f2\u0006\u0010\u001b\u001a\u00020\u0010J \u0010\u001c\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u001d\u001a\u00020\f2\u0006\u0010\u001e\u001a\u00020\u001fJ\u000e\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\u0014J\u0006\u0010#\u001a\u00020\u0019R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u001e\u0010\n\u001a\u0012\u0012\u0004\u0012\u00020\f0\u000bj\b\u0012\u0004\u0012\u00020\f`\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u000e\u001a\u0014\u0012\u0004\u0012\u00020\u0010\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00120\u00110\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lnl/chimpgamer/ultimatemobcoins/paper/managers/MobCoinManager;", "", "plugin", "Lnl/chimpgamer/ultimatemobcoins/paper/UltimateMobCoinsPlugin;", "<init>", "(Lnl/chimpgamer/ultimatemobcoins/paper/UltimateMobCoinsPlugin;)V", "config", "Ldev/dejvokep/boostedyaml/YamlDocument;", "getConfig", "()Ldev/dejvokep/boostedyaml/YamlDocument;", "mobCoinsList", "Ljava/util/ArrayList;", "Lnl/chimpgamer/ultimatemobcoins/paper/models/MobCoin;", "Lkotlin/collections/ArrayList;", "recentEarnings", "", "", "", "Lnl/chimpgamer/ultimatemobcoins/paper/managers/MobCoinManager$EarningEntry;", "checkRecentEarnings", "Ljava/math/BigDecimal;", "killer", "Lorg/bukkit/entity/Player;", "amount", "loadMobCoins", "", "getMobCoin", "entityType", "getCoinDropAmount", "mobCoin", "multiplier", "", "createMobCoinItem", "Lorg/bukkit/inventory/ItemStack;", "dropAmount", "reload", "EarningEntry", "paper"})
@SourceDebugExtension(value={"SMAP\nMobCoinManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MobCoinManager.kt\nnl/chimpgamer/ultimatemobcoins/paper/managers/MobCoinManager\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 ExPersistentDataHolder.kt\nnl/chimpgamer/ultimatemobcoins/paper/extensions/ExPersistentDataHolderKt\n*L\n1#1,117:1\n382#2,7:118\n1#3:125\n1#3:136\n1617#4,9:126\n1869#4:135\n1870#4:137\n1626#4:138\n1869#4,2:139\n295#4,2:141\n10#5:143\n*S KotlinDebug\n*F\n+ 1 MobCoinManager.kt\nnl/chimpgamer/ultimatemobcoins/paper/managers/MobCoinManager\n*L\n33#1:118,7\n61#1:136\n61#1:126,9\n61#1:135\n61#1:137\n61#1:138\n61#1:139,2\n78#1:141,2\n90#1:143\n*E\n"})
public final class MobCoinManager {
    @NotNull
    private final UltimateMobCoinsPlugin plugin;
    @NotNull
    private final YamlDocument config;
    @NotNull
    private final ArrayList<MobCoin> mobCoinsList;
    @NotNull
    private final Map<String, List<EarningEntry>> recentEarnings;

    public MobCoinManager(@NotNull UltimateMobCoinsPlugin plugin) {
        YamlDocument yamlDocument;
        Intrinsics.checkNotNullParameter((Object)plugin, (String)"plugin");
        this.plugin = plugin;
        this.mobCoinsList = new ArrayList();
        this.recentEarnings = new LinkedHashMap();
        File file = this.plugin.getDataFolder();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"getDataFolder(...)");
        File file2 = FilesKt.resolve((File)file, (String)"mobcoins.yml");
        InputStream inputStream = this.plugin.getResource("mobcoins.yml");
        GeneralSettings generalSettings = GeneralSettings.builder().setUseDefaults(false).build();
        if (inputStream != null) {
            var6_5 = new Settings[]{generalSettings, LoaderSettings.DEFAULT, DumperSettings.DEFAULT, UpdaterSettings.DEFAULT};
            yamlDocument = YamlDocument.create((File)file2, (InputStream)inputStream, (Settings[])var6_5);
        } else {
            var6_5 = new Settings[]{generalSettings, LoaderSettings.DEFAULT, DumperSettings.DEFAULT, UpdaterSettings.DEFAULT};
            yamlDocument = YamlDocument.create((File)file2, (Settings[])var6_5);
        }
        YamlDocument yamlDocument2 = yamlDocument;
        Intrinsics.checkNotNull((Object)yamlDocument2);
        this.config = yamlDocument2;
    }

    @NotNull
    public final YamlDocument getConfig() {
        return this.config;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final BigDecimal checkRecentEarnings(@NotNull Player killer, @NotNull BigDecimal amount) {
        Intrinsics.checkNotNullParameter((Object)killer, (String)"killer");
        Intrinsics.checkNotNullParameter((Object)amount, (String)"amount");
        BigDecimal dropAmount = amount;
        if (this.plugin.getSettingsConfig().getMobCoinsEarningsPenaltyEnabled()) {
            Object object;
            Iterable answer$iv;
            void $this$getOrPut$iv;
            Map<String, List<EarningEntry>> map2 = this.recentEarnings;
            String key$iv = killer.getUniqueId().toString();
            boolean $i$f$getOrPut = false;
            Object value$iv = $this$getOrPut$iv.get(key$iv);
            if (value$iv == null) {
                boolean bl = false;
                answer$iv = new ArrayList();
                $this$getOrPut$iv.put(key$iv, answer$iv);
                object = answer$iv;
            } else {
                object = value$iv;
            }
            List playerEarnings = (List)object;
            String string = this.plugin.getSettingsConfig().getMobCoinsEarningsPenaltyCooldownUnit().toUpperCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toUpperCase(...)");
            ChronoUnit unit = ChronoUnit.valueOf(string);
            Instant ago = Instant.now().minus(this.plugin.getSettingsConfig().getMobCoinsEarningsPenaltyCooldownValue(), unit);
            playerEarnings.removeIf(arg_0 -> MobCoinManager.checkRecentEarnings$lambda$2(arg_0 -> MobCoinManager.checkRecentEarnings$lambda$1(ago, arg_0), arg_0));
            answer$iv = playerEarnings;
            double d = 0.0;
            for (Object e : answer$iv) {
                void it;
                EarningEntry earningEntry = (EarningEntry)e;
                double d2 = d;
                boolean bl = false;
                double d3 = it.getAmount().doubleValue();
                d = d2 + d3;
            }
            double recentTotal = d;
            double earningsPenaltyThreshold = this.plugin.getSettingsConfig().getMobCoinsEarningsPenaltyThreshold();
            if (recentTotal >= earningsPenaltyThreshold) {
                String type = this.plugin.getSettingsConfig().getMobCoinsEarningsPenaltyType();
                double value = this.plugin.getSettingsConfig().getMobCoinsEarningsPenaltyValue();
                if (value <= 0.0) {
                    return dropAmount;
                }
                if (StringsKt.equals((String)type, (String)"percentage", (boolean)true)) {
                    BigDecimal bigDecimal = new BigDecimal(String.valueOf(value));
                    BigDecimal bigDecimal2 = BigDecimal.valueOf(100);
                    Intrinsics.checkNotNullExpressionValue((Object)bigDecimal2, (String)"valueOf(...)");
                    BigDecimal bigDecimal3 = dropAmount.multiply(bigDecimal.divide(bigDecimal2));
                    Intrinsics.checkNotNullExpressionValue((Object)bigDecimal3, (String)"multiply(...)");
                    dropAmount = bigDecimal3;
                } else if (StringsKt.equals((String)type, (String)"fixed", (boolean)true)) {
                    double d4 = value;
                    MathContext mathContext = new MathContext(3);
                    dropAmount = new BigDecimal(String.valueOf(d4), mathContext);
                } else {
                    return dropAmount;
                }
            }
            Instant instant = Instant.now();
            Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"now(...)");
            playerEarnings.add(new EarningEntry(dropAmount, instant));
        }
        return dropAmount;
    }

    /*
     * WARNING - void declaration
     */
    public final void loadMobCoins() {
        Object element$iv$iv;
        void $this$mapNotNullTo$iv$iv;
        this.mobCoinsList.clear();
        Section section = this.config.getSection("mobCoinDrops");
        if (section == null) {
            return;
        }
        Section mobCoinDrops = section;
        Set set = mobCoinDrops.getKeys();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"getKeys(...)");
        Iterable $this$mapNotNull$iv = set;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            String it$iv$iv;
            Object element$iv$iv$iv;
            element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            Object it = element$iv$iv;
            boolean bl2 = false;
            if (it.toString() == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach2 = false;
        for (Object element$iv : $this$forEach$iv) {
            String entityType;
            Object object;
            String key = (String)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)key.toUpperCase(Locale.ROOT), (String)"toUpperCase(...)");
            Double chance = mobCoinDrops.getDouble(key + ".chance");
            String amountStr = mobCoinDrops.getString(key + ".amount");
            Intrinsics.checkNotNull((Object)amountStr);
            if (StringsKt.contains$default((CharSequence)amountStr, (CharSequence)"-", (boolean)false, (int)2, null)) {
                element$iv$iv = new String[]{"-"};
                var12_16 = (double[])StringsKt.split$default((CharSequence)amountStr, element$iv$iv, (boolean)false, (int)2, (int)2, null);
                String min = (String)var12_16.get(0);
                String max = (String)var12_16.get(1);
                double[] dArray = new double[2];
                Double d = StringsKt.toDoubleOrNull((String)min);
                dArray[0] = d != null ? d : 0.0;
                Double d2 = StringsKt.toDoubleOrNull((String)max);
                dArray[1] = d2 != null ? d2 : 0.0;
                object = dArray;
            } else {
                var12_16 = new double[2];
                Double d = StringsKt.toDoubleOrNull((String)amountStr);
                var12_16[0] = d != null ? d : 0.0;
                var12_16[1] = 0.0;
                object = var12_16;
            }
            double[] amount = object;
            Intrinsics.checkNotNull((Object)chance);
            this.mobCoinsList.add(new MobCoin(this.plugin, entityType, chance, amount));
        }
        this.plugin.getLogger().info("Loaded " + this.mobCoinsList.size() + " mobcoin drops");
    }

    @Nullable
    public final MobCoin getMobCoin(@NotNull String entityType) {
        Object v0;
        block1: {
            Intrinsics.checkNotNullParameter((Object)entityType, (String)"entityType");
            Iterable $this$firstOrNull$iv = this.mobCoinsList;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                MobCoin it = (MobCoin)element$iv;
                boolean bl = false;
                if (!StringsKt.equals((String)it.getEntityType(), (String)entityType, (boolean)true)) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    @Nullable
    public final BigDecimal getCoinDropAmount(@NotNull Player killer, @NotNull MobCoin mobCoin, double multiplier) {
        Intrinsics.checkNotNullParameter((Object)killer, (String)"killer");
        Intrinsics.checkNotNullParameter((Object)mobCoin, (String)"mobCoin");
        BigDecimal dropAmount = mobCoin.getAmountToDrop(killer);
        return Intrinsics.areEqual((Object)dropAmount, (Object)BigDecimal.ZERO) ? null : this.plugin.applyMultiplier(dropAmount, multiplier);
    }

    @NotNull
    public final ItemStack createMobCoinItem(@NotNull BigDecimal dropAmount) {
        Intrinsics.checkNotNullParameter((Object)dropAmount, (String)"dropAmount");
        SettingsConfig settingsConfig = this.plugin.getSettingsConfig();
        TagResolver.Single single = Placeholder.unparsed((String)"amount", (String)dropAmount.toString());
        Intrinsics.checkNotNullExpressionValue((Object)single, (String)"unparsed(...)");
        ItemStack mobCoinItem = settingsConfig.getMobCoinsItem((TagResolver)single);
        mobCoinItem.editMeta(arg_0 -> MobCoinManager.createMobCoinItem$lambda$1(arg_0 -> MobCoinManager.createMobCoinItem$lambda$0(dropAmount, arg_0), arg_0));
        return mobCoinItem;
    }

    public final void reload() {
        this.config.reload();
        this.loadMobCoins();
    }

    private static final boolean checkRecentEarnings$lambda$1(Instant $ago, EarningEntry it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getTimestamp().isBefore($ago);
    }

    private static final boolean checkRecentEarnings$lambda$2(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final Unit createMobCoinItem$lambda$0(BigDecimal $dropAmount, ItemMeta meta) {
        PersistentDataContainer persistentDataContainer;
        Intrinsics.checkNotNull((Object)meta);
        PersistentDataHolder $this$pdc$iv = (PersistentDataHolder)meta;
        boolean $i$f$pdc = false;
        PersistentDataContainer persistentDataContainer2 = $this$pdc$iv.getPersistentDataContainer();
        Intrinsics.checkNotNullExpressionValue((Object)persistentDataContainer2, (String)"getPersistentDataContainer(...)");
        PersistentDataContainer $this$createMobCoinItem_u24lambda_u240_u240 = persistentDataContainer = persistentDataContainer2;
        boolean bl = false;
        ExPersistentDataHolderKt.setBoolean($this$createMobCoinItem_u24lambda_u240_u240, NamespacedKeys.INSTANCE.isMobCoin(), true);
        ExPersistentDataHolderKt.setDouble($this$createMobCoinItem_u24lambda_u240_u240, NamespacedKeys.INSTANCE.getMobCoinAmount(), $dropAmount.doubleValue());
        return Unit.INSTANCE;
    }

    private static final void createMobCoinItem$lambda$1(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0016"}, d2={"Lnl/chimpgamer/ultimatemobcoins/paper/managers/MobCoinManager$EarningEntry;", "", "amount", "Ljava/math/BigDecimal;", "timestamp", "Ljava/time/Instant;", "<init>", "(Ljava/math/BigDecimal;Ljava/time/Instant;)V", "getAmount", "()Ljava/math/BigDecimal;", "getTimestamp", "()Ljava/time/Instant;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "paper"})
    private static final class EarningEntry {
        @NotNull
        private final BigDecimal amount;
        @NotNull
        private final Instant timestamp;

        public EarningEntry(@NotNull BigDecimal amount, @NotNull Instant timestamp) {
            Intrinsics.checkNotNullParameter((Object)amount, (String)"amount");
            Intrinsics.checkNotNullParameter((Object)timestamp, (String)"timestamp");
            this.amount = amount;
            this.timestamp = timestamp;
        }

        @NotNull
        public final BigDecimal getAmount() {
            return this.amount;
        }

        @NotNull
        public final Instant getTimestamp() {
            return this.timestamp;
        }

        @NotNull
        public final BigDecimal component1() {
            return this.amount;
        }

        @NotNull
        public final Instant component2() {
            return this.timestamp;
        }

        @NotNull
        public final EarningEntry copy(@NotNull BigDecimal amount, @NotNull Instant timestamp) {
            Intrinsics.checkNotNullParameter((Object)amount, (String)"amount");
            Intrinsics.checkNotNullParameter((Object)timestamp, (String)"timestamp");
            return new EarningEntry(amount, timestamp);
        }

        public static /* synthetic */ EarningEntry copy$default(EarningEntry earningEntry, BigDecimal bigDecimal, Instant instant, int n, Object object) {
            if ((n & 1) != 0) {
                bigDecimal = earningEntry.amount;
            }
            if ((n & 2) != 0) {
                instant = earningEntry.timestamp;
            }
            return earningEntry.copy(bigDecimal, instant);
        }

        @NotNull
        public String toString() {
            return "EarningEntry(amount=" + this.amount + ", timestamp=" + this.timestamp + ")";
        }

        public int hashCode() {
            int result = this.amount.hashCode();
            result = result * 31 + this.timestamp.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof EarningEntry)) {
                return false;
            }
            EarningEntry earningEntry = (EarningEntry)other;
            if (!Intrinsics.areEqual((Object)this.amount, (Object)earningEntry.amount)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.timestamp, (Object)earningEntry.timestamp);
        }
    }
}

