/*
 * Decompiled with CFR 0.152.
 */
package nl.chimpgamer.ultimatemobcoins.paper.hooks.betonquest.objectives;

import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import nl.chimpgamer.ultimatemobcoins.paper.events.MobCoinsReceiveEvent;
import nl.chimpgamer.ultimatemobcoins.paper.extensions.PluginExtKt;
import org.betonquest.betonquest.Instruction;
import org.betonquest.betonquest.api.Objective;
import org.betonquest.betonquest.api.profiles.OnlineProfile;
import org.betonquest.betonquest.api.profiles.Profile;
import org.betonquest.betonquest.instruction.variable.VariableNumber;
import org.betonquest.betonquest.utils.PlayerConverter;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0016\u0018\u00002\u00020\u00012\u00020\u0002:\u0001\u0015B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0007J\b\u0010\r\u001a\u00020\nH\u0016J\b\u0010\u000e\u001a\u00020\nH\u0016J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\u0012\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0016J\u0018\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lnl/chimpgamer/ultimatemobcoins/paper/hooks/betonquest/objectives/MobCoinsReceiveObjective;", "Lorg/betonquest/betonquest/api/Objective;", "Lorg/bukkit/event/Listener;", "instruction", "Lorg/betonquest/betonquest/Instruction;", "<init>", "(Lorg/betonquest/betonquest/Instruction;)V", "targetAmount", "Lorg/betonquest/betonquest/instruction/variable/VariableNumber;", "onMobCoinsReceive", "", "event", "Lnl/chimpgamer/ultimatemobcoins/paper/events/MobCoinsReceiveEvent;", "start", "stop", "getDefaultDataInstruction", "", "profile", "Lorg/betonquest/betonquest/api/profiles/Profile;", "getProperty", "name", "MobCoinData", "paper"})
public class MobCoinsReceiveObjective
extends Objective
implements Listener {
    @NotNull
    private VariableNumber targetAmount;

    public MobCoinsReceiveObjective(@NotNull Instruction instruction) {
        Intrinsics.checkNotNullParameter((Object)instruction, (String)"instruction");
        super(instruction);
        this.template = MobCoinData.class;
        VariableNumber variableNumber = instruction.getVarNum();
        Intrinsics.checkNotNullExpressionValue((Object)variableNumber, (String)"getVarNum(...)");
        this.targetAmount = variableNumber;
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public final void onMobCoinsReceive(@NotNull MobCoinsReceiveEvent event) {
        Intrinsics.checkNotNullParameter((Object)((Object)event), (String)"event");
        OnlineProfile onlineProfile = PlayerConverter.getID((Player)event.getPlayer());
        if (this.containsPlayer((Profile)onlineProfile) && this.checkConditions((Profile)onlineProfile)) {
            Object v = this.dataMap.get(onlineProfile);
            Intrinsics.checkNotNull(v, (String)"null cannot be cast to non-null type nl.chimpgamer.ultimatemobcoins.paper.hooks.betonquest.objectives.MobCoinsReceiveObjective.MobCoinData");
            MobCoinData data = (MobCoinData)((Object)v);
            data.add(event.getAmount().doubleValue());
            if (data.isCompleted()) {
                this.completeObjective((Profile)onlineProfile);
            }
        }
    }

    public void start() {
        JavaPlugin javaPlugin = JavaPlugin.getProvidingPlugin(((Object)((Object)this)).getClass());
        Intrinsics.checkNotNullExpressionValue((Object)javaPlugin, (String)"getProvidingPlugin(...)");
        Listener[] listenerArray = new Listener[]{this};
        PluginExtKt.registerEvents((Plugin)javaPlugin, listenerArray);
    }

    public void stop() {
        HandlerList.unregisterAll((Listener)this);
    }

    @NotNull
    public String getDefaultDataInstruction() {
        return this.targetAmount.toString();
    }

    @NotNull
    public String getDefaultDataInstruction(@Nullable Profile profile) {
        double value = ((Number)this.targetAmount.getValue(profile)).doubleValue();
        return value > 0.0 ? String.valueOf(value) : "1";
    }

    @NotNull
    public String getProperty(@NotNull String name, @NotNull Profile profile) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)profile, (String)"profile");
        String string = name.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
        return switch (string) {
            case "amount" -> {
                Object v1 = this.dataMap.get(profile);
                Intrinsics.checkNotNull(v1, (String)"null cannot be cast to non-null type nl.chimpgamer.ultimatemobcoins.paper.hooks.betonquest.objectives.MobCoinsReceiveObjective.MobCoinData");
                yield String.valueOf(((MobCoinData)((Object)v1)).getAmount());
            }
            case "left" -> {
                Object v3 = this.dataMap.get(profile);
                Intrinsics.checkNotNull(v3, (String)"null cannot be cast to non-null type nl.chimpgamer.ultimatemobcoins.paper.hooks.betonquest.objectives.MobCoinsReceiveObjective.MobCoinData");
                MobCoinData data = (MobCoinData)((Object)v3);
                yield String.valueOf(data.getTargetAmount() - data.getAmount());
            }
            case "total" -> {
                Object v4 = this.dataMap.get(profile);
                Intrinsics.checkNotNull(v4, (String)"null cannot be cast to non-null type nl.chimpgamer.ultimatemobcoins.paper.hooks.betonquest.objectives.MobCoinsReceiveObjective.MobCoinData");
                yield String.valueOf(((MobCoinData)((Object)v4)).getTargetAmount());
            }
            default -> "";
        };
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0006\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0004\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0007\u0010\bJ\u000e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\r\u001a\u00020\nJ\b\u0010\u0016\u001a\u00020\u0003H\u0016R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001a\u0010\r\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\f\"\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0013\u001a\u00020\u00148F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0015\u00a8\u0006\u0017"}, d2={"Lnl/chimpgamer/ultimatemobcoins/paper/hooks/betonquest/objectives/MobCoinsReceiveObjective$MobCoinData;", "Lorg/betonquest/betonquest/api/Objective$ObjectiveData;", "instruction", "", "profile", "Lorg/betonquest/betonquest/api/profiles/Profile;", "objID", "<init>", "(Ljava/lang/String;Lorg/betonquest/betonquest/api/profiles/Profile;Ljava/lang/String;)V", "targetAmount", "", "getTargetAmount", "()D", "amount", "getAmount", "setAmount", "(D)V", "add", "", "isCompleted", "", "()Z", "toString", "paper"})
    protected static final class MobCoinData
    extends Objective.ObjectiveData {
        private final double targetAmount;
        private double amount;

        public MobCoinData(@NotNull String instruction, @Nullable Profile profile, @Nullable String objID) {
            Intrinsics.checkNotNullParameter((Object)instruction, (String)"instruction");
            super(instruction, profile, objID);
            this.targetAmount = Double.parseDouble(instruction);
        }

        public final double getTargetAmount() {
            return this.targetAmount;
        }

        public final double getAmount() {
            return this.amount;
        }

        public final void setAmount(double d) {
            this.amount = d;
        }

        public final void add(double amount) {
            this.amount += amount;
            this.update();
        }

        public final boolean isCompleted() {
            return this.amount >= this.targetAmount;
        }

        @NotNull
        public String toString() {
            return this.amount + "/" + this.targetAmount;
        }
    }
}

