/*
 * Decompiled with CFR 0.152.
 */
package nl.chimpgamer.ultimatemobcoins.paper.hooks;

import java.math.BigDecimal;
import java.util.logging.Logger;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import net.milkbowl.vault.economy.Economy;
import net.milkbowl.vault.economy.EconomyResponse;
import nl.chimpgamer.ultimatemobcoins.paper.UltimateMobCoinsPlugin;
import nl.chimpgamer.ultimatemobcoins.paper.hooks.PluginHook;
import nl.chimpgamer.ultimatemobcoins.paper.hooks.Response;
import nl.chimpgamer.ultimatemobcoins.paper.hooks.vault.VaultEconomy;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.RegisteredServiceProvider;
import org.bukkit.plugin.ServicePriority;
import org.bukkit.plugin.ServicesManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\tH\u0016J\u0006\u0010\u000b\u001a\u00020\tJ\u0010\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000fJ\u0016\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\rJ\u0016\u0010\u0013\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\rJ\u0006\u0010\u0014\u001a\u00020\u0015R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lnl/chimpgamer/ultimatemobcoins/paper/hooks/VaultHook;", "Lnl/chimpgamer/ultimatemobcoins/paper/hooks/PluginHook;", "plugin", "Lnl/chimpgamer/ultimatemobcoins/paper/UltimateMobCoinsPlugin;", "<init>", "(Lnl/chimpgamer/ultimatemobcoins/paper/UltimateMobCoinsPlugin;)V", "economy", "Lnet/milkbowl/vault/economy/Economy;", "load", "", "unload", "example", "get", "Ljava/math/BigDecimal;", "offlinePlayer", "Lorg/bukkit/OfflinePlayer;", "give", "Lnl/chimpgamer/ultimatemobcoins/paper/hooks/Response;", "amount", "take", "isInitialized", "", "paper"})
public final class VaultHook
extends PluginHook {
    private Economy economy;

    public VaultHook(@NotNull UltimateMobCoinsPlugin plugin) {
        Intrinsics.checkNotNullParameter((Object)plugin, (String)"plugin");
        super(plugin, "Vault");
    }

    @Override
    public void load() {
        if (!this.canHook()) {
            return;
        }
        ServicesManager servicesManager = this.getPlugin().getServer().getServicesManager();
        Intrinsics.checkNotNullExpressionValue((Object)servicesManager, (String)"getServicesManager(...)");
        ServicesManager servicesManager2 = servicesManager;
        if (this.getPlugin().getHooksConfig().getVaultProvideEconomy()) {
            servicesManager2.register(Economy.class, (Object)new VaultEconomy(this.getPlugin()), (Plugin)this.getPlugin(), ServicePriority.High);
            this.getPlugin().getLogger().info("Registered UltimateMobCoins as Economy Provider into Vault");
        }
        RegisteredServiceProvider registeredServiceProvider = servicesManager2.getRegistration(Economy.class);
        if (registeredServiceProvider == null) {
            return;
        }
        RegisteredServiceProvider rsp = registeredServiceProvider;
        Object object = rsp.getProvider();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getProvider(...)");
        this.economy = (Economy)object;
        this.setLoaded(true);
        Logger logger = this.getPlugin().getLogger();
        String string = this.getPluginName();
        Economy economy = this.economy;
        if (economy == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"economy");
            economy = null;
        }
        logger.info("Successfully loaded " + string + " hook! (" + economy.getName() + ")");
    }

    @Override
    public void unload() {
        this.setLoaded(false);
    }

    public final void example() {
        Player player = Bukkit.getPlayer((String)"playername");
        if (player == null) {
            return;
        }
        Player player2 = player;
        this.take((OfflinePlayer)player2, new BigDecimal(100)).handle(() -> VaultHook.example$lambda$0(player2), (Function1<? super String, Unit>)((Function1)arg_0 -> VaultHook.example$lambda$1(player2, arg_0)));
    }

    @Nullable
    public final BigDecimal get(@NotNull OfflinePlayer offlinePlayer) {
        Intrinsics.checkNotNullParameter((Object)offlinePlayer, (String)"offlinePlayer");
        if (!this.isInitialized()) {
            return null;
        }
        Economy economy = this.economy;
        if (economy == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"economy");
            economy = null;
        }
        return new BigDecimal(economy.getBalance(offlinePlayer));
    }

    @NotNull
    public final Response give(@NotNull OfflinePlayer offlinePlayer, @NotNull BigDecimal amount) {
        Response response;
        EconomyResponse response2;
        Intrinsics.checkNotNullParameter((Object)offlinePlayer, (String)"offlinePlayer");
        Intrinsics.checkNotNullParameter((Object)amount, (String)"amount");
        if (!this.isInitialized()) {
            return Response.Companion.failing("Vault has not been initialized!");
        }
        Economy economy = this.economy;
        if (economy == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"economy");
            economy = null;
        }
        if ((response2 = economy.depositPlayer(offlinePlayer, amount.doubleValue())).transactionSuccess()) {
            response = Response.Companion.passing();
        } else {
            String string = response2.errorMessage;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"errorMessage");
            response = Response.Companion.failing(string);
        }
        return response;
    }

    @NotNull
    public final Response take(@NotNull OfflinePlayer offlinePlayer, @NotNull BigDecimal amount) {
        Response response;
        EconomyResponse response2;
        Intrinsics.checkNotNullParameter((Object)offlinePlayer, (String)"offlinePlayer");
        Intrinsics.checkNotNullParameter((Object)amount, (String)"amount");
        if (!this.isInitialized()) {
            return Response.Companion.failing("Vault has not been initialized!");
        }
        Economy economy = this.economy;
        if (economy == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"economy");
            economy = null;
        }
        if ((response2 = economy.withdrawPlayer(offlinePlayer, amount.doubleValue())).transactionSuccess()) {
            response = Response.Companion.passing();
        } else {
            String string = response2.errorMessage;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"errorMessage");
            response = Response.Companion.failing(string);
        }
        return response;
    }

    public final boolean isInitialized() {
        return this.economy != null;
    }

    private static final void example$lambda$0(Player $player) {
        $player.sendRichMessage("<green>100$ has been taken from your account!");
    }

    private static final Unit example$lambda$1(Player $player, String reason) {
        Intrinsics.checkNotNullParameter((Object)reason, (String)"reason");
        $player.sendRichMessage(reason);
        return Unit.INSTANCE;
    }
}

