/*
 * Decompiled with CFR 0.152.
 */
package nl.chimpgamer.ultimatemobcoins.paper.configurations;

import dev.dejvokep.boostedyaml.YamlDocument;
import dev.dejvokep.boostedyaml.block.implementation.Section;
import dev.dejvokep.boostedyaml.settings.Settings;
import dev.dejvokep.boostedyaml.settings.dumper.DumperSettings;
import dev.dejvokep.boostedyaml.settings.general.GeneralSettings;
import dev.dejvokep.boostedyaml.settings.loader.LoaderSettings;
import dev.dejvokep.boostedyaml.settings.updater.UpdaterSettings;
import java.io.File;
import java.io.InputStream;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import nl.chimpgamer.ultimatemobcoins.paper.UltimateMobCoinsPlugin;
import nl.chimpgamer.ultimatemobcoins.paper.models.menu.MenuType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0006\u0010\u0012\u001a\u00020\u0013J\u0006\u0010\u0014\u001a\u00020\u0013J\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0017\u001a\u00020\u0018J\u0010\u0010\u0019\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u001a\u001a\u00020\u0018J\u001a\u0010\u0019\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u001a\u001a\u00020\u00182\b\u0010\u001b\u001a\u0004\u0018\u00010\u0018J\u000e\u0010\u001c\u001a\u00020\u00132\u0006\u0010\u001a\u001a\u00020\u0018J\u0016\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001a\u001a\u00020\u00182\u0006\u0010\u001b\u001a\u00020\u001eJ\u0015\u0010\u001f\u001a\u0004\u0018\u00010 2\u0006\u0010\u001a\u001a\u00020\u0018\u00a2\u0006\u0002\u0010!J\u0014\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u001e0#2\u0006\u0010\u001a\u001a\u00020\u0018J9\u0010$\u001a\u0002H%\"\u000e\b\u0000\u0010%*\b\u0012\u0004\u0012\u0002H%0&2\u0006\u0010\u001a\u001a\u00020\u00182\f\u0010'\u001a\b\u0012\u0004\u0012\u0002H%0(2\u0006\u0010\u001b\u001a\u0002H%\u00a2\u0006\u0002\u0010)R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u000e\u001a\u00020\u000f8F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006*"}, d2={"Lnl/chimpgamer/ultimatemobcoins/paper/configurations/MenuConfig;", "", "plugin", "Lnl/chimpgamer/ultimatemobcoins/paper/UltimateMobCoinsPlugin;", "file", "Ljava/io/File;", "<init>", "(Lnl/chimpgamer/ultimatemobcoins/paper/UltimateMobCoinsPlugin;Ljava/io/File;)V", "getFile", "()Ljava/io/File;", "config", "Ldev/dejvokep/boostedyaml/YamlDocument;", "getConfig", "()Ldev/dejvokep/boostedyaml/YamlDocument;", "menuType", "Lnl/chimpgamer/ultimatemobcoins/paper/models/menu/MenuType;", "getMenuType", "()Lnl/chimpgamer/ultimatemobcoins/paper/models/menu/MenuType;", "hasResetTimer", "", "reload", "getSection", "Ldev/dejvokep/boostedyaml/block/implementation/Section;", "section", "", "getString", "route", "def", "getBoolean", "getInt", "", "getLong", "", "(Ljava/lang/String;)Ljava/lang/Long;", "getIntList", "", "getEnum", "T", "", "clazz", "Lkotlin/reflect/KClass;", "(Ljava/lang/String;Lkotlin/reflect/KClass;Ljava/lang/Enum;)Ljava/lang/Enum;", "paper"})
public final class MenuConfig {
    @NotNull
    private final File file;
    @NotNull
    private final YamlDocument config;

    public MenuConfig(@NotNull UltimateMobCoinsPlugin plugin, @NotNull File file) {
        YamlDocument yamlDocument;
        Intrinsics.checkNotNullParameter((Object)plugin, (String)"plugin");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        this.file = file;
        InputStream inputStream = plugin.getResource("shops/" + this.file.getName());
        GeneralSettings generalSettings = GeneralSettings.builder().setDefaultString(null).setDefaultObject(null).setKeyFormat(GeneralSettings.KeyFormat.STRING).setUseDefaults(false).build();
        if (inputStream != null) {
            var6_5 = new Settings[]{generalSettings, LoaderSettings.DEFAULT, DumperSettings.DEFAULT, UpdaterSettings.DEFAULT};
            yamlDocument = YamlDocument.create((File)this.file, (InputStream)inputStream, (Settings[])var6_5);
        } else {
            var6_5 = new Settings[]{generalSettings, LoaderSettings.DEFAULT, DumperSettings.DEFAULT, UpdaterSettings.DEFAULT};
            yamlDocument = YamlDocument.create((File)this.file, (Settings[])var6_5);
        }
        YamlDocument yamlDocument2 = yamlDocument;
        Intrinsics.checkNotNull((Object)yamlDocument2);
        this.config = yamlDocument2;
    }

    @NotNull
    public final File getFile() {
        return this.file;
    }

    @NotNull
    public final YamlDocument getConfig() {
        return this.config;
    }

    @NotNull
    public final MenuType getMenuType() {
        return (MenuType)this.getEnum("type", Reflection.getOrCreateKotlinClass(MenuType.class), (Enum)MenuType.NORMAL);
    }

    public final boolean hasResetTimer() {
        Long refreshTime = this.config.getLong("refresh_time");
        return refreshTime != null && refreshTime > 0L;
    }

    public final boolean reload() {
        return this.config.reload();
    }

    @Nullable
    public final Section getSection(@NotNull String section) {
        Intrinsics.checkNotNullParameter((Object)section, (String)"section");
        return this.config.getSection(section);
    }

    @Nullable
    public final String getString(@NotNull String route) {
        Intrinsics.checkNotNullParameter((Object)route, (String)"route");
        return this.config.getString(route);
    }

    @Nullable
    public final String getString(@NotNull String route, @Nullable String def) {
        Intrinsics.checkNotNullParameter((Object)route, (String)"route");
        return this.config.getString(route, def);
    }

    public final boolean getBoolean(@NotNull String route) {
        Intrinsics.checkNotNullParameter((Object)route, (String)"route");
        Boolean bl = this.config.getBoolean(route);
        Intrinsics.checkNotNullExpressionValue((Object)bl, (String)"getBoolean(...)");
        return bl;
    }

    public final int getInt(@NotNull String route, int def) {
        Intrinsics.checkNotNullParameter((Object)route, (String)"route");
        Integer n = this.config.getInt(route, Integer.valueOf(def));
        Intrinsics.checkNotNullExpressionValue((Object)n, (String)"getInt(...)");
        return ((Number)n).intValue();
    }

    @Nullable
    public final Long getLong(@NotNull String route) {
        Intrinsics.checkNotNullParameter((Object)route, (String)"route");
        return this.config.getLong(route);
    }

    @NotNull
    public final List<Integer> getIntList(@NotNull String route) {
        Intrinsics.checkNotNullParameter((Object)route, (String)"route");
        List list = this.config.getIntList(route);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getIntList(...)");
        return list;
    }

    @NotNull
    public final <T extends Enum<T>> T getEnum(@NotNull String route, @NotNull KClass<T> clazz, @NotNull T def) {
        Intrinsics.checkNotNullParameter((Object)route, (String)"route");
        Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
        Intrinsics.checkNotNullParameter(def, (String)"def");
        Enum enum_ = this.config.getEnum(route, JvmClassMappingKt.getJavaClass(clazz), def);
        Intrinsics.checkNotNullExpressionValue((Object)enum_, (String)"getEnum(...)");
        return (T)enum_;
    }
}

