/*
 * Decompiled with CFR 0.152.
 */
package cn.xor7.iseeyou.commandapi.arguments;

import cn.xor7.iseeyou.commandapi.CommandAPIBukkit;
import cn.xor7.iseeyou.commandapi.arguments.CommandAPIArgumentType;
import cn.xor7.iseeyou.commandapi.arguments.LocationType;
import cn.xor7.iseeyou.commandapi.arguments.SafeOverrideableArgument;
import cn.xor7.iseeyou.commandapi.executors.CommandArguments;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import org.bukkit.Location;

public class LocationArgument
extends SafeOverrideableArgument<Location, Location> {
    private final boolean isPrecise;

    public LocationArgument(String nodeName) {
        this(nodeName, LocationType.PRECISE_POSITION);
    }

    public LocationArgument(String nodeName, LocationType type) {
        this(nodeName, type, true);
    }

    public LocationArgument(String nodeName, LocationType type, boolean centerPosition) {
        super(nodeName, type == LocationType.BLOCK_POSITION ? CommandAPIBukkit.get()._ArgumentPosition() : CommandAPIBukkit.get()._ArgumentVec3(centerPosition), type == LocationType.BLOCK_POSITION ? l -> l.getBlockX() + " " + l.getBlockY() + " " + l.getBlockZ() : l -> l.getX() + " " + l.getY() + " " + l.getZ());
        this.isPrecise = type == LocationType.PRECISE_POSITION;
    }

    public LocationType getLocationType() {
        return this.isPrecise ? LocationType.PRECISE_POSITION : LocationType.BLOCK_POSITION;
    }

    @Override
    public Class<Location> getPrimitiveType() {
        return Location.class;
    }

    @Override
    public CommandAPIArgumentType getArgumentType() {
        return CommandAPIArgumentType.LOCATION;
    }

    @Override
    public <CommandSourceStack> Location parseArgument(CommandContext<CommandSourceStack> cmdCtx, String key, CommandArguments previousArgs) throws CommandSyntaxException {
        return this.isPrecise ? CommandAPIBukkit.get().getLocationPrecise(cmdCtx, key) : CommandAPIBukkit.get().getLocationBlock(cmdCtx, key);
    }
}

