/*
 * Decompiled with CFR 0.152.
 */
package cn.xor7.iseeyou.commandapi;

import cn.xor7.iseeyou.commandapi.CommandAPIConfig;
import java.io.File;
import java.util.List;
import java.util.function.Function;

public class InternalConfig {
    private final boolean verboseOutput;
    private final boolean silentLogs;
    private final boolean useLatestNMSVersion;
    private final boolean beLenientForMinorVersions;
    private final String messageMissingExecutorImplementation;
    private final File dispatcherFile;
    private final List<String> skipSenderProxy;
    private Class<?> nbtContainerClass;
    private Function<Object, ?> nbtContainerConstructor;
    private final String namespace;

    public InternalConfig(CommandAPIConfig<?> config) {
        this.verboseOutput = config.verboseOutput;
        this.silentLogs = config.silentLogs;
        this.useLatestNMSVersion = config.useLatestNMSVersion;
        this.beLenientForMinorVersions = config.beLenientForMinorVersions;
        this.messageMissingExecutorImplementation = config.missingExecutorImplementationMessage;
        this.dispatcherFile = config.dispatcherFile;
        this.skipSenderProxy = config.skipSenderProxy;
        this.nbtContainerClass = config.nbtContainerClass;
        this.nbtContainerConstructor = config.nbtContainerConstructor;
        this.namespace = config.namespace;
    }

    public boolean hasVerboseOutput() {
        return this.verboseOutput;
    }

    public boolean hasSilentLogs() {
        return this.silentLogs;
    }

    public boolean shouldUseLatestNMSVersion() {
        return this.useLatestNMSVersion;
    }

    public boolean shouldBeLenientForMinorVersions() {
        return this.beLenientForMinorVersions;
    }

    public String getMissingImplementationMessage() {
        return this.messageMissingExecutorImplementation;
    }

    public File getDispatcherFile() {
        return this.dispatcherFile;
    }

    public boolean shouldSkipSenderProxy(String commandName) {
        return this.skipSenderProxy.contains(commandName);
    }

    public Class<?> getNBTContainerClass() {
        return this.nbtContainerClass;
    }

    public Function<Object, ?> getNBTContainerConstructor() {
        return this.nbtContainerConstructor;
    }

    public void lateInitializeNBT(Class<?> nbtContainerClass, Function<Object, ?> nbtContainerConstructor) {
        this.nbtContainerClass = nbtContainerClass;
        this.nbtContainerConstructor = nbtContainerConstructor;
    }

    public String getNamespace() {
        return this.namespace;
    }
}

