/*
 * Decompiled with CFR 0.152.
 */
package de.celduinx.totalxprewards;

import de.celduinx.totalxprewards.TotalXPRewardsPlugin;
import java.util.HashMap;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerCommandPreprocessEvent;
import org.bukkit.event.player.PlayerExpChangeEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.server.ServerCommandEvent;
import org.bukkit.plugin.Plugin;

public class XPListener
implements Listener {
    private final TotalXPRewardsPlugin plugin;

    public XPListener(TotalXPRewardsPlugin plugin) {
        this.plugin = plugin;
    }

    @EventHandler(ignoreCancelled=true)
    public void onPlayerExpChange(PlayerExpChangeEvent event) {
        int amount = event.getAmount();
        if (amount <= 0) {
            return;
        }
        this.plugin.handleXpGain(event.getPlayer(), amount);
    }

    @EventHandler(ignoreCancelled=true)
    public void onPlayerCommand(PlayerCommandPreprocessEvent event) {
        String msg = event.getMessage().toLowerCase();
        if (msg.startsWith("/xp ") || msg.startsWith("/experience ") || msg.equals("/xp") || msg.equals("/experience")) {
            this.handleXpCommand();
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onServerCommand(ServerCommandEvent event) {
        String cmd = event.getCommand().toLowerCase();
        if (cmd.startsWith("xp ") || cmd.startsWith("experience ") || cmd.equals("xp") || cmd.equals("experience")) {
            this.handleXpCommand();
        }
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        if (this.plugin.getBossBarManager() != null) {
            UUID uuid = event.getPlayer().getUniqueId();
            Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> {
                long xp = this.plugin.getDatabase().getXp(uuid);
                Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> {
                    if (event.getPlayer().isOnline()) {
                        this.plugin.getBossBarManager().update(event.getPlayer(), xp);
                    }
                });
            });
        }
    }

    @EventHandler
    public void onPlayerQuit(PlayerQuitEvent event) {
        if (this.plugin.getBossBarManager() != null) {
            this.plugin.getBossBarManager().remove(event.getPlayer());
        }
    }

    private void handleXpCommand() {
        HashMap<UUID, Integer> beforeXp = new HashMap<UUID, Integer>();
        for (Player p : Bukkit.getOnlinePlayers()) {
            beforeXp.put(p.getUniqueId(), p.getTotalExperience());
        }
        Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> {
            for (Player p : Bukkit.getOnlinePlayers()) {
                if (!beforeXp.containsKey(p.getUniqueId())) continue;
                int oldTotal = (Integer)beforeXp.get(p.getUniqueId());
                int newTotal = p.getTotalExperience();
                int diff = newTotal - oldTotal;
                if (diff <= 0) continue;
                this.plugin.handleXpGain(p, diff);
            }
        });
    }
}

