/*
 * Decompiled with CFR 0.152.
 */
package de.celduinx.totalxprewards;

import java.io.File;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.UUID;
import org.bukkit.plugin.Plugin;

public class XPDatabase {
    private final Plugin plugin;
    private final Object lock = new Object();
    private Connection connection;

    public XPDatabase(Plugin plugin) {
        this.plugin = plugin;
        this.init();
    }

    private void init() {
        try {
            File dbFolder = this.plugin.getDataFolder();
            if (!dbFolder.exists() && !dbFolder.mkdirs()) {
                this.plugin.getLogger().warning("Could not create plugin data folder");
            }
            File dbFile = new File(dbFolder, "totalxp.db");
            String url = "jdbc:sqlite:" + dbFile.getAbsolutePath();
            this.connection = DriverManager.getConnection(url);
            this.plugin.getLogger().info("Connected to SQLite database.");
            try (Statement st = this.connection.createStatement();){
                st.executeUpdate("CREATE TABLE IF NOT EXISTS player_xp (uuid TEXT PRIMARY KEY,xp INTEGER NOT NULL)");
                this.migrateTable(st);
                st.executeUpdate("CREATE TABLE IF NOT EXISTS player_rewards (uuid TEXT NOT NULL,threshold INTEGER NOT NULL,PRIMARY KEY (uuid, threshold))");
            }
        }
        catch (SQLException e) {
            this.plugin.getLogger().severe("Could not initialise SQLite database: " + e.getMessage());
        }
    }

    private void migrateTable(Statement st) {
        try {
            st.executeUpdate("ALTER TABLE player_xp ADD COLUMN username TEXT");
            this.plugin.getLogger().info("Database: Added 'username' column.");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        try {
            st.executeUpdate("ALTER TABLE player_xp ADD COLUMN current_rank TEXT");
            this.plugin.getLogger().info("Database: Added 'current_rank' column.");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public long getXp(UUID uuid) {
        Object object = this.lock;
        synchronized (object) {
            block18: {
                if (this.connection == null) {
                    return 0L;
                }
                String sql = "SELECT xp FROM player_xp WHERE uuid = ?";
                try (PreparedStatement ps = this.connection.prepareStatement(sql);){
                    ps.setString(1, uuid.toString());
                    ResultSet rs = ps.executeQuery();
                    if (!rs.next()) break block18;
                    long l = rs.getLong("xp");
                    return l;
                    finally {
                        if (rs != null) {
                            rs.close();
                        }
                    }
                }
                catch (SQLException e) {
                    this.plugin.getLogger().severe("Error reading XP from database: " + e.getMessage());
                }
            }
            return 0L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPlayerData(UUID uuid, long xp, String username, String rank) {
        Object object = this.lock;
        synchronized (object) {
            if (this.connection == null) {
                return;
            }
            String sql = "INSERT INTO player_xp (uuid, xp, username, current_rank) VALUES (?, ?, ?, ?) ON CONFLICT(uuid) DO UPDATE SET xp = excluded.xp, username = excluded.username, current_rank = excluded.current_rank";
            try (PreparedStatement ps = this.connection.prepareStatement(sql);){
                ps.setString(1, uuid.toString());
                ps.setLong(2, xp);
                ps.setString(3, username);
                ps.setString(4, rank);
                ps.executeUpdate();
            }
            catch (SQLException e) {
                this.plugin.getLogger().severe("Error saving player data to database: " + e.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setXp(UUID uuid, long xp) {
        Object object = this.lock;
        synchronized (object) {
            if (this.connection == null) {
                return;
            }
            String sql = "INSERT INTO player_xp (uuid, xp) VALUES (?, ?) ON CONFLICT(uuid) DO UPDATE SET xp = excluded.xp";
            try (PreparedStatement ps = this.connection.prepareStatement(sql);){
                ps.setString(1, uuid.toString());
                ps.setLong(2, xp);
                ps.executeUpdate();
            }
            catch (SQLException e) {
                this.plugin.getLogger().severe("Error saving XP to database: " + e.getMessage());
            }
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public boolean hasReward(UUID uuid, long threshold) {
        if (this.connection == null) {
            return false;
        }
        String sql = "SELECT 1 FROM player_rewards WHERE uuid = ? AND threshold = ?";
        try (PreparedStatement ps = this.connection.prepareStatement(sql);){
            boolean bl;
            block15: {
                ps.setString(1, uuid.toString());
                ps.setLong(2, threshold);
                ResultSet rs = ps.executeQuery();
                try {
                    bl = rs.next();
                    if (rs == null) break block15;
                }
                catch (Throwable throwable) {
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                rs.close();
            }
            return bl;
        }
        catch (SQLException e) {
            this.plugin.getLogger().severe("Error checking reward in database: " + e.getMessage());
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRewardGiven(UUID uuid, long threshold) {
        Object object = this.lock;
        synchronized (object) {
            if (this.connection == null) {
                return;
            }
            String sql = "INSERT OR IGNORE INTO player_rewards (uuid, threshold) VALUES (?, ?)";
            try (PreparedStatement ps = this.connection.prepareStatement(sql);){
                ps.setString(1, uuid.toString());
                ps.setLong(2, threshold);
                ps.executeUpdate();
            }
            catch (SQLException e) {
                this.plugin.getLogger().severe("Error saving reward to database: " + e.getMessage());
            }
        }
    }

    public void resetPlayer(UUID uuid) {
        if (this.connection == null) {
            return;
        }
        try (PreparedStatement ps1 = this.connection.prepareStatement("DELETE FROM player_xp WHERE uuid = ?");
             PreparedStatement ps2 = this.connection.prepareStatement("DELETE FROM player_rewards WHERE uuid = ?");){
            ps1.setString(1, uuid.toString());
            ps1.executeUpdate();
            ps2.setString(1, uuid.toString());
            ps2.executeUpdate();
        }
        catch (SQLException e) {
            this.plugin.getLogger().severe("Error resetting player in database: " + e.getMessage());
        }
    }

    public void close() {
        if (this.connection != null) {
            try {
                this.connection.close();
                this.plugin.getLogger().info("SQLite database connection closed.");
            }
            catch (SQLException e) {
                this.plugin.getLogger().severe("Error closing database connection: " + e.getMessage());
            }
        }
    }
}

