/*
 * Decompiled with CFR 0.152.
 */
package de.celduinx.totalxprewards;

import de.celduinx.totalxprewards.BossBarManager;
import de.celduinx.totalxprewards.CommandTotalXP;
import de.celduinx.totalxprewards.Lang;
import de.celduinx.totalxprewards.Metrics;
import de.celduinx.totalxprewards.PlayerData;
import de.celduinx.totalxprewards.PlayerDataManager;
import de.celduinx.totalxprewards.Reward;
import de.celduinx.totalxprewards.XPDatabase;
import de.celduinx.totalxprewards.XPListener;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.UUID;
import me.clip.placeholderapi.PlaceholderAPI;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.PluginCommand;
import org.bukkit.command.TabCompleter;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public final class TotalXPRewardsPlugin
extends JavaPlugin {
    private static final int CONFIG_VERSION = 1;
    private static TotalXPRewardsPlugin instance;
    private XPDatabase database;
    private final Map<Long, Reward> rewards = new TreeMap<Long, Reward>();
    private BossBarManager bossBarManager;
    private PlayerDataManager playerDataManager;

    public static TotalXPRewardsPlugin getInstance() {
        return instance;
    }

    public void onEnable() {
        instance = this;
        this.saveDefaultConfig();
        if (!new File(this.getDataFolder(), "lang.yml").exists()) {
            this.saveResource("lang.yml", false);
        }
        this.migrateConfig();
        Lang.init(this);
        this.database = new XPDatabase((Plugin)this);
        this.playerDataManager = new PlayerDataManager(this);
        this.reloadSettings();
        this.bossBarManager = new BossBarManager(this);
        this.getServer().getPluginManager().registerEvents((Listener)new XPListener(this), (Plugin)this);
        CommandTotalXP cmd = new CommandTotalXP(this);
        PluginCommand command = this.getCommand("totalxp");
        if (command != null) {
            command.setExecutor((CommandExecutor)cmd);
            command.setTabCompleter((TabCompleter)cmd);
        } else {
            this.getLogger().severe("Command 'totalxp' not found in plugin.yml!");
        }
        int pluginId = 28208;
        new Metrics((Plugin)this, pluginId);
        this.getLogger().info("TotalXPRewards enabled.");
    }

    private void migrateConfig() {
        File configFile = new File(this.getDataFolder(), "config.yml");
        if (!configFile.exists()) {
            return;
        }
        YamlConfiguration config = YamlConfiguration.loadConfiguration((File)configFile);
        int currentVersion = config.getInt("config-version", 0);
        boolean changed = false;
        if (currentVersion < 1) {
            this.getLogger().info("Migrating configuration from v" + currentVersion + " to v1...");
            if (currentVersion < 1) {
                if (!config.isConfigurationSection("bossbar")) {
                    config.set("bossbar.enabled", (Object)true);
                    config.set("bossbar.dynamic-mode", (Object)false);
                    config.set("bossbar.timeout", (Object)10);
                    config.set("bossbar.title", (Object)"&bNext Rank: &e%next_rank% &7(&a%xp%&7/&c%required_xp%&7)");
                    config.set("bossbar.color", (Object)"BLUE");
                    config.set("bossbar.style", (Object)"SOLID");
                    changed = true;
                } else {
                    if (!config.contains("bossbar.dynamic-mode")) {
                        config.set("bossbar.dynamic-mode", (Object)false);
                        changed = true;
                    }
                    if (!config.contains("bossbar.timeout")) {
                        config.set("bossbar.timeout", (Object)10);
                        changed = true;
                    }
                }
                ConfigurationSection rewardsSection = config.getConfigurationSection("rewards");
                if (rewardsSection != null) {
                    for (String key : rewardsSection.getKeys(false)) {
                        if (rewardsSection.contains(key + ".name")) continue;
                        config.set("rewards." + key + ".name", (Object)("Rank " + key));
                        changed = true;
                    }
                }
            }
            config.set("config-version", (Object)1);
            changed = true;
        }
        if (changed) {
            try {
                config.save(configFile);
                this.getLogger().info("Config migration complete. Saved to disk.");
                this.reloadConfig();
            }
            catch (IOException e) {
                this.getLogger().severe("Could not save migrated config: " + e.getMessage());
            }
        }
    }

    public void reloadSettings() {
        this.reloadConfig();
        Lang.reload(this);
        this.loadRewards();
        if (this.bossBarManager != null) {
            this.bossBarManager.reload();
        }
    }

    private void loadRewards() {
        this.rewards.clear();
        ConfigurationSection section = this.getConfig().getConfigurationSection("rewards");
        if (section == null) {
            this.getLogger().warning("No rewards section found in config.yml");
            return;
        }
        for (String key : section.getKeys(false)) {
            try {
                String single;
                long threshold = Long.parseLong(key);
                List<String> commands = section.getStringList(key + ".commands");
                String broadcast = section.getString(key + ".broadcast", "");
                String name = section.getString(key + ".name", "Rank " + threshold);
                if (commands.isEmpty() && (single = section.getString(key + ".command")) != null && !single.isEmpty()) {
                    commands = Collections.singletonList(single);
                }
                if ((commands == null || commands.isEmpty()) && (broadcast == null || broadcast.isEmpty())) {
                    this.getLogger().warning("Reward " + key + " has no commands and no broadcast, skipping.");
                    continue;
                }
                Reward reward = new Reward(threshold, commands, broadcast, name);
                this.rewards.put(threshold, reward);
            }
            catch (NumberFormatException e) {
                this.getLogger().warning("Invalid reward key (not numeric): " + key);
            }
        }
        this.getLogger().info("Loaded " + this.rewards.size() + " rewards from config.");
    }

    public XPDatabase getDatabase() {
        return this.database;
    }

    public Map<Long, Reward> getRewards() {
        return this.rewards;
    }

    public BossBarManager getBossBarManager() {
        return this.bossBarManager;
    }

    public PlayerDataManager getPlayerDataManager() {
        return this.playerDataManager;
    }

    public void handleXpGain(Player player, int amount) {
        Map.Entry<Long, Reward> entry;
        long threshold;
        if (amount <= 0) {
            return;
        }
        UUID uuid = player.getUniqueId();
        PlayerData data = this.playerDataManager.getData(uuid);
        if (data == null) {
            return;
        }
        data.addXp(amount);
        long newTotal = data.getTotalXp();
        data.setCurrentRankName(this.getRankName(newTotal));
        long current = newTotal - (long)amount;
        if (this.bossBarManager != null) {
            this.bossBarManager.update(player, newTotal);
        }
        Iterator<Map.Entry<Long, Reward>> iterator = this.rewards.entrySet().iterator();
        while (iterator.hasNext() && (threshold = (entry = iterator.next()).getKey().longValue()) <= newTotal) {
            if (threshold <= current || this.database.hasReward(uuid, threshold)) continue;
            Reward reward = entry.getValue();
            this.executeReward(player, reward, newTotal, threshold);
            this.database.setRewardGiven(uuid, threshold);
        }
    }

    private void executeReward(Player player, Reward reward, long xp, long threshold) {
        String msg;
        for (String command : reward.getCommands()) {
            if (command == null || command.isEmpty()) continue;
            String cmd = this.format(player, command, xp, threshold, false);
            if (cmd.startsWith("/")) {
                cmd = cmd.substring(1);
            }
            Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)cmd);
        }
        String broadcast = reward.getBroadcast();
        if (broadcast != null && !broadcast.isEmpty() && (msg = this.format(player, broadcast, xp, threshold, true)) != null && !msg.isEmpty()) {
            Bukkit.broadcastMessage((String)(Lang.get("prefix") + msg));
        }
    }

    public String format(Player player, String text, long xp, long threshold, boolean colour) {
        Component comp = this.formatToComponent(player, text, xp, threshold);
        return LegacyComponentSerializer.legacySection().serialize(comp);
    }

    public String getRankName(long xp) {
        String currentRankName = "None";
        for (Map.Entry<Long, Reward> entry : this.rewards.entrySet()) {
            if (entry.getKey() > xp) break;
            currentRankName = entry.getValue().getName();
        }
        return currentRankName;
    }

    public Component formatToComponent(Player player, String text, long xp, long threshold) {
        if (text == null || text.isEmpty()) {
            return Component.empty();
        }
        if (text.contains("%current_rank%")) {
            text = text.replace("%current_rank%", this.getRankName(xp));
        }
        if (text.contains("%next_rank%") || text.contains("%required_xp%")) {
            String nextRankName = Lang.get("max-rank");
            long nextThresholdVal = -1L;
            for (Map.Entry<Long, Reward> entry : this.rewards.entrySet()) {
                if (entry.getKey() <= xp) continue;
                nextRankName = entry.getValue().getName();
                nextThresholdVal = entry.getKey();
                break;
            }
            text = text.replace("%next_rank%", nextRankName);
            text = nextThresholdVal != -1L ? text.replace("%required_xp%", String.valueOf(nextThresholdVal)) : text.replace("%required_xp%", "0");
        }
        text = text.replace("%player%", player.getName()).replace("%xp%", String.valueOf(xp)).replace("%threshold%", String.valueOf(threshold));
        if (this.isPlaceholderAPIEnabled()) {
            try {
                text = PlaceholderAPI.setPlaceholders((Player)player, (String)text);
            }
            catch (Throwable t) {
                this.getLogger().warning("Error applying PlaceholderAPI: " + t.getMessage());
            }
        }
        if (text.contains("&")) {
            text = this.convertLegacyToMiniMessage(text);
        }
        return MiniMessage.miniMessage().deserialize((Object)text);
    }

    private String convertLegacyToMiniMessage(String text) {
        return text.replace("&0", "<black>").replace("&1", "<dark_blue>").replace("&2", "<dark_green>").replace("&3", "<dark_aqua>").replace("&4", "<dark_red>").replace("&5", "<dark_purple>").replace("&6", "<gold>").replace("&7", "<gray>").replace("&8", "<dark_gray>").replace("&9", "<blue>").replace("&a", "<green>").replace("&b", "<aqua>").replace("&c", "<red>").replace("&d", "<light_purple>").replace("&e", "<yellow>").replace("&f", "<white>").replace("&k", "<obfuscated>").replace("&l", "<bold>").replace("&m", "<strikethrough>").replace("&n", "<underlined>").replace("&o", "<italic>").replace("&r", "<reset>").replace("&A", "<green>").replace("&B", "<aqua>").replace("&C", "<red>").replace("&D", "<light_purple>").replace("&E", "<yellow>").replace("&F", "<white>").replace("&K", "<obfuscated>").replace("&L", "<bold>").replace("&M", "<strikethrough>").replace("&N", "<underlined>").replace("&O", "<italic>").replace("&R", "<reset>");
    }

    public boolean isPlaceholderAPIEnabled() {
        boolean configUsePapi = this.getConfig().getBoolean("settings.use-placeholderapi", true);
        boolean hasPapi = this.getServer().getPluginManager().getPlugin("PlaceholderAPI") != null;
        return configUsePapi && hasPapi;
    }
}

