/*
 * Decompiled with CFR 0.152.
 */
package de.celduinx.totalxprewards;

import de.celduinx.totalxprewards.PlayerData;
import de.celduinx.totalxprewards.TotalXPRewardsPlugin;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.AsyncPlayerPreLoginEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.plugin.Plugin;

public class PlayerDataManager
implements Listener {
    private final TotalXPRewardsPlugin plugin;
    private final Map<UUID, PlayerData> dataMap = new ConcurrentHashMap<UUID, PlayerData>();

    public PlayerDataManager(TotalXPRewardsPlugin plugin) {
        this.plugin = plugin;
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
        for (Player p : Bukkit.getOnlinePlayers()) {
            this.load(p.getUniqueId(), p.getName(), true);
        }
    }

    @EventHandler
    public void onAsyncLogin(AsyncPlayerPreLoginEvent event) {
        if (event.getLoginResult() == AsyncPlayerPreLoginEvent.Result.ALLOWED) {
            this.load(event.getUniqueId(), event.getName(), false);
        }
    }

    @EventHandler
    public void onJoin(PlayerJoinEvent event) {
        if (!this.dataMap.containsKey(event.getPlayer().getUniqueId())) {
            this.load(event.getPlayer().getUniqueId(), event.getPlayer().getName(), true);
        }
    }

    @EventHandler
    public void onQuit(PlayerQuitEvent event) {
        this.saveAndRemove(event.getPlayer().getUniqueId());
    }

    private void load(UUID uuid, String name, boolean async) {
        if (this.dataMap.containsKey(uuid)) {
            return;
        }
        Runnable loadTask = () -> {
            long xp = this.plugin.getDatabase().getXp(uuid);
            PlayerData data = new PlayerData(uuid, name, xp);
            String rank = this.plugin.getRankName(xp);
            data.setCurrentRankName(rank);
            this.dataMap.put(uuid, data);
        };
        if (async) {
            Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, loadTask);
        } else {
            loadTask.run();
        }
    }

    private void saveAndRemove(UUID uuid) {
        PlayerData data = this.dataMap.remove(uuid);
        if (data != null) {
            Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> this.plugin.getDatabase().setPlayerData(uuid, data.getTotalXp(), data.getName(), data.getCurrentRankName()));
            if (data.getBossBar() != null) {
                data.getBossBar().removeAll();
            }
        }
    }

    public void saveAll() {
        for (PlayerData data : this.dataMap.values()) {
            this.plugin.getDatabase().setPlayerData(data.getUuid(), data.getTotalXp(), data.getName(), data.getCurrentRankName());
        }
    }

    public PlayerData getData(UUID uuid) {
        return this.dataMap.get(uuid);
    }

    public PlayerData getData(Player player) {
        return this.getData(player.getUniqueId());
    }
}

