/*
 * Decompiled with CFR 0.152.
 */
package de.celduinx.totalxprewards;

import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.ChatColor;
import org.bukkit.configuration.Configuration;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.java.JavaPlugin;

public final class Lang {
    private static FileConfiguration config;
    private static final Map<String, Object> defaults;

    private Lang() {
    }

    public static void init(JavaPlugin plugin) {
        defaults.put("prefix", "&7[&aTotalXP&7] ");
        defaults.put("no-permission", "&cYou do not have permission.");
        defaults.put("player-not-found", "&cPlayer not found.");
        defaults.put("invalid-number", "&cPlease enter a valid number.");
        defaults.put("negative-amount", "&cAmount must not be negative.");
        defaults.put("xp-view", "&a%player% has &e%xp% &atotal XP.");
        defaults.put("xp-set", "&aSet &e%player%&a's XP to &e%amount%.");
        defaults.put("xp-reset", "&aReset XP of &e%player%&a.");
        defaults.put("max-rank", "Max Rank");
        defaults.put("reload-done", "&aTotal XP Rewards config and language reloaded.");
        defaults.put("help", Arrays.asList("&7---- &aTotal XP Rewards Help &7----", "&a/%label% get <player> &7- Show player's total XP", "&a/%label% set <player> <amount> &7- Set player's total XP", "&a/%label% reset <player> &7- Reset player's total XP", "&a/%label% reload &7- Reload config and language"));
        Lang.reload(plugin);
    }

    public static void reload(JavaPlugin plugin) {
        File file = new File(plugin.getDataFolder(), "lang.yml");
        if (!file.exists()) {
            plugin.saveResource("lang.yml", false);
        }
        config = YamlConfiguration.loadConfiguration((File)file);
        InputStream defConfigStream = plugin.getResource("lang.yml");
        if (defConfigStream != null) {
            YamlConfiguration defConfig = YamlConfiguration.loadConfiguration((Reader)new InputStreamReader(defConfigStream));
            config.setDefaults((Configuration)defConfig);
        }
    }

    public static String get(String key) {
        Object val = config.get(key);
        if (val == null) {
            val = defaults.get(key);
        }
        if (val == null) {
            return "";
        }
        if (val instanceof String) {
            return ChatColor.translateAlternateColorCodes((char)'&', (String)((String)val));
        }
        return val.toString();
    }

    public static List<String> getList(String key) {
        Object def;
        List list = config.getStringList(key);
        if ((list == null || list.isEmpty()) && (def = defaults.get(key)) instanceof List) {
            list = (List)def;
        }
        if (list != null) {
            for (int i = 0; i < list.size(); ++i) {
                list.set(i, ChatColor.translateAlternateColorCodes((char)'&', (String)((String)list.get(i))));
            }
        }
        return list;
    }

    static {
        defaults = new HashMap<String, Object>();
    }
}

