/*
 * Decompiled with CFR 0.152.
 */
package de.celduinx.totalxprewards;

import de.celduinx.totalxprewards.Lang;
import de.celduinx.totalxprewards.PlayerData;
import de.celduinx.totalxprewards.TotalXPRewardsPlugin;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class CommandTotalXP
implements CommandExecutor,
TabCompleter {
    private final TotalXPRewardsPlugin plugin;

    public CommandTotalXP(TotalXPRewardsPlugin plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        String sub;
        if (args.length == 0) {
            this.sendHelp(sender, label);
            return true;
        }
        switch (sub = args[0].toLowerCase()) {
            case "get": {
                this.handleGet(sender, args);
                break;
            }
            case "set": {
                this.handleSet(sender, args);
                break;
            }
            case "reset": {
                this.handleReset(sender, args);
                break;
            }
            case "reload": {
                this.handleReload(sender);
                break;
            }
            case "show": {
                this.handleShow(sender);
                break;
            }
            case "hide": {
                this.handleHide(sender);
                break;
            }
            default: {
                this.sendHelp(sender, label);
            }
        }
        return true;
    }

    private void sendHelp(CommandSender sender, String label) {
        List<String> lines = Lang.getList("help");
        if (lines == null) {
            return;
        }
        for (String line : lines) {
            sender.sendMessage(line.replace("%label%", label));
        }
    }

    private List<OfflinePlayer> resolveTargets(CommandSender sender, String arg) {
        OfflinePlayer target;
        ArrayList<OfflinePlayer> targets = new ArrayList<OfflinePlayer>();
        try {
            List entities = Bukkit.selectEntities((CommandSender)sender, (String)arg);
            for (Entity entity : entities) {
                if (!(entity instanceof Player)) continue;
                targets.add((OfflinePlayer)((Player)entity));
            }
        }
        catch (IllegalArgumentException | NoSuchMethodError entities) {
            // empty catch block
        }
        if (targets.isEmpty() && ((target = Bukkit.getOfflinePlayer((String)arg)).hasPlayedBefore() || target.getName() != null || target.isOnline())) {
            targets.add(target);
        }
        return targets;
    }

    private void handleGet(CommandSender sender, String[] args) {
        if (!sender.hasPermission("totalxp.view")) {
            sender.sendMessage(Lang.get("no-permission"));
            return;
        }
        if (args.length < 2) {
            this.sendHelp(sender, "totalxp");
            return;
        }
        List<OfflinePlayer> targets = this.resolveTargets(sender, args[1]);
        if (targets.isEmpty()) {
            sender.sendMessage(Lang.get("player-not-found"));
            return;
        }
        for (OfflinePlayer target : targets) {
            UUID uuid = target.getUniqueId();
            String name = target.getName() != null ? target.getName() : args[1];
            PlayerData data = this.plugin.getPlayerDataManager().getData(uuid);
            long xp = data != null ? data.getTotalXp() : this.plugin.getDatabase().getXp(uuid);
            String msg = Lang.get("xp-view").replace("%player%", name).replace("%xp%", String.valueOf(xp));
            sender.sendMessage(msg);
        }
    }

    private void handleSet(CommandSender sender, String[] args) {
        long amount;
        if (!sender.hasPermission("totalxp.admin")) {
            sender.sendMessage(Lang.get("no-permission"));
            return;
        }
        if (args.length < 3) {
            this.sendHelp(sender, "totalxp");
            return;
        }
        String amountStr = args[2];
        try {
            amount = Long.parseLong(amountStr);
            if (amount < 0L) {
                sender.sendMessage(Lang.get("negative-amount"));
                return;
            }
        }
        catch (NumberFormatException e) {
            sender.sendMessage(Lang.get("invalid-number"));
            return;
        }
        List<OfflinePlayer> targets = this.resolveTargets(sender, args[1]);
        if (targets.isEmpty()) {
            sender.sendMessage(Lang.get("player-not-found"));
            return;
        }
        for (OfflinePlayer target : targets) {
            UUID uuid = target.getUniqueId();
            String name = target.getName() != null ? target.getName() : "?";
            PlayerData data = this.plugin.getPlayerDataManager().getData(uuid);
            if (data != null) {
                data.setTotalXp(amount);
                data.setCurrentRankName(this.plugin.getRankName(amount));
                Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> this.plugin.getDatabase().setPlayerData(uuid, amount, name, data.getCurrentRankName()));
            } else {
                String rankName = this.plugin.getRankName(amount);
                this.plugin.getDatabase().setPlayerData(uuid, amount, name, rankName);
            }
            String msg = Lang.get("xp-set").replace("%player%", name).replace("%amount%", String.valueOf(amount));
            sender.sendMessage(msg);
            if (!target.isOnline()) continue;
            this.plugin.getBossBarManager().update((Player)target, amount);
        }
    }

    private void handleReset(CommandSender sender, String[] args) {
        if (!sender.hasPermission("totalxp.admin")) {
            sender.sendMessage(Lang.get("no-permission"));
            return;
        }
        if (args.length < 2) {
            this.sendHelp(sender, "totalxp");
            return;
        }
        List<OfflinePlayer> targets = this.resolveTargets(sender, args[1]);
        if (targets.isEmpty()) {
            sender.sendMessage(Lang.get("player-not-found"));
            return;
        }
        for (OfflinePlayer target : targets) {
            UUID uuid = target.getUniqueId();
            String name = target.getName() != null ? target.getName() : "?";
            this.plugin.getDatabase().resetPlayer(uuid);
            PlayerData data = this.plugin.getPlayerDataManager().getData(uuid);
            if (data != null) {
                data.setTotalXp(0L);
            }
            String msg = Lang.get("xp-reset").replace("%player%", name);
            sender.sendMessage(msg);
            if (!target.isOnline()) continue;
            this.plugin.getBossBarManager().update((Player)target, 0L);
        }
    }

    private void handleReload(CommandSender sender) {
        if (!sender.hasPermission("totalxp.admin")) {
            sender.sendMessage(Lang.get("no-permission"));
            return;
        }
        this.plugin.reloadSettings();
        sender.sendMessage(Lang.get("prefix") + "Configuration reloaded.");
    }

    private void handleShow(CommandSender sender) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(Lang.get("prefix") + "Only players can use this command.");
            return;
        }
        Player player = (Player)sender;
        if (this.plugin.getBossBarManager() != null) {
            this.plugin.getBossBarManager().showBar(player);
            player.sendMessage(Lang.get("prefix") + "BossBar shown.");
        }
    }

    private void handleHide(CommandSender sender) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(Lang.get("prefix") + "Only players can use this command.");
            return;
        }
        Player player = (Player)sender;
        if (this.plugin.getBossBarManager() != null) {
            this.plugin.getBossBarManager().hideBar(player);
            player.sendMessage(Lang.get("prefix") + "BossBar hidden.");
        }
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        ArrayList<String> result = new ArrayList<String>();
        if (args.length == 1) {
            String prefix = args[0].toLowerCase();
            if ("get".startsWith(prefix)) {
                result.add("get");
            }
            if ("set".startsWith(prefix) && sender.hasPermission("totalxp.admin")) {
                result.add("set");
            }
            if ("reset".startsWith(prefix) && sender.hasPermission("totalxp.admin")) {
                result.add("reset");
            }
            if ("reload".startsWith(prefix) && sender.hasPermission("totalxp.admin")) {
                result.add("reload");
            }
            if ("show".startsWith(prefix)) {
                result.add("show");
            }
            if ("hide".startsWith(prefix)) {
                result.add("hide");
            }
            return result;
        }
        if (args.length == 2 && (args[0].equalsIgnoreCase("get") || args[0].equalsIgnoreCase("set") || args[0].equalsIgnoreCase("reset"))) {
            String namePrefix = args[1].toLowerCase();
            if ("@a".startsWith(namePrefix)) {
                result.add("@a");
            }
            if ("@p".startsWith(namePrefix)) {
                result.add("@p");
            }
            if ("@r".startsWith(namePrefix)) {
                result.add("@r");
            }
            if ("@s".startsWith(namePrefix)) {
                result.add("@s");
            }
            if ("@e".startsWith(namePrefix)) {
                result.add("@e");
            }
            for (Player p : Bukkit.getOnlinePlayers()) {
                if (!p.getName().toLowerCase().startsWith(namePrefix)) continue;
                result.add(p.getName());
            }
        }
        return result;
    }
}

