/*
 * Decompiled with CFR 0.152.
 */
package de.celduinx.totalxprewards;

import de.celduinx.totalxprewards.PlayerData;
import de.celduinx.totalxprewards.Reward;
import de.celduinx.totalxprewards.TotalXPRewardsPlugin;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.boss.BarColor;
import org.bukkit.boss.BarFlag;
import org.bukkit.boss.BarStyle;
import org.bukkit.boss.BossBar;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class BossBarManager {
    private final TotalXPRewardsPlugin plugin;
    private final Map<UUID, BossBar> bossBars = new HashMap<UUID, BossBar>();
    private final Set<UUID> hiddenPlayers = new HashSet<UUID>();
    private final Map<UUID, Integer> hideTasks = new HashMap<UUID, Integer>();
    private boolean enabled;
    private boolean dynamicMode;
    private int timeout;
    private String titleTemplate;
    private BarColor barColor;
    private BarStyle barStyle;

    public BossBarManager(TotalXPRewardsPlugin plugin) {
        this.plugin = plugin;
        this.reload();
    }

    public void reload() {
        this.enabled = this.plugin.getConfig().getBoolean("bossbar.enabled", false);
        this.dynamicMode = this.plugin.getConfig().getBoolean("bossbar.dynamic-mode", false);
        this.timeout = this.plugin.getConfig().getInt("bossbar.timeout", 5);
        this.titleTemplate = this.plugin.getConfig().getString("bossbar.title", "Next Rank: %next_rank%");
        String colorStr = this.plugin.getConfig().getString("bossbar.color", "BLUE");
        try {
            this.barColor = BarColor.valueOf((String)colorStr.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            this.plugin.getLogger().warning("Invalid bossbar color: " + colorStr + ". Defaulting to BLUE.");
            this.barColor = BarColor.BLUE;
        }
        String styleStr = this.plugin.getConfig().getString("bossbar.style", "SOLID");
        try {
            this.barStyle = BarStyle.valueOf((String)styleStr.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            this.plugin.getLogger().warning("Invalid bossbar style: " + styleStr + ". Defaulting to SOLID.");
            this.barStyle = BarStyle.SOLID;
        }
        for (Player player : Bukkit.getOnlinePlayers()) {
            if (this.enabled && !this.hiddenPlayers.contains(player.getUniqueId())) {
                PlayerData data = this.plugin.getPlayerDataManager().getData(player.getUniqueId());
                long xp = data != null ? data.getTotalXp() : 0L;
                this.update(player, xp);
                continue;
            }
            this.remove(player);
        }
    }

    public void showBar(Player player) {
        this.hiddenPlayers.remove(player.getUniqueId());
        PlayerData data = this.plugin.getPlayerDataManager().getData(player.getUniqueId());
        long xp = data != null ? data.getTotalXp() : 0L;
        this.update(player, xp);
    }

    public void hideBar(Player player) {
        this.hiddenPlayers.add(player.getUniqueId());
        this.remove(player);
    }

    public void remove(Player player) {
        BossBar bar = this.bossBars.remove(player.getUniqueId());
        if (bar != null) {
            bar.removeAll();
        }
        if (this.hideTasks.containsKey(player.getUniqueId())) {
            Bukkit.getScheduler().cancelTask(this.hideTasks.get(player.getUniqueId()).intValue());
            this.hideTasks.remove(player.getUniqueId());
        }
    }

    public void update(Player player, long currentXp) {
        if (!this.enabled || this.hiddenPlayers.contains(player.getUniqueId())) {
            if (this.bossBars.containsKey(player.getUniqueId())) {
                this.remove(player);
            }
            return;
        }
        long nextThreshold = -1L;
        long prevThreshold = 0L;
        for (Map.Entry<Long, Reward> entry : this.plugin.getRewards().entrySet()) {
            long threshold = entry.getKey();
            if (threshold > currentXp) {
                nextThreshold = threshold;
                break;
            }
            prevThreshold = threshold;
        }
        BossBar bar = this.bossBars.computeIfAbsent(player.getUniqueId(), k -> {
            BossBar b = Bukkit.createBossBar((String)"", (BarColor)this.barColor, (BarStyle)this.barStyle, (BarFlag[])new BarFlag[0]);
            b.addPlayer(player);
            return b;
        });
        bar.setColor(this.barColor);
        bar.setStyle(this.barStyle);
        bar.setVisible(true);
        if (nextThreshold == -1L) {
            String maxTitle = ChatColor.translateAlternateColorCodes((char)'&', (String)"&aMax Rank Reached");
            bar.setTitle(maxTitle);
            bar.setProgress(1.0);
            return;
        }
        double range = nextThreshold - prevThreshold;
        double currentInRange = currentXp - prevThreshold;
        double progress = 0.0;
        if (range > 0.0) {
            progress = currentInRange / range;
        }
        progress = Math.max(0.0, Math.min(1.0, progress));
        bar.setProgress(progress);
        String title = this.plugin.format(player, this.titleTemplate, currentXp, nextThreshold, true);
        bar.setTitle(title);
        if (this.dynamicMode) {
            if (this.hideTasks.containsKey(player.getUniqueId())) {
                Bukkit.getScheduler().cancelTask(this.hideTasks.get(player.getUniqueId()).intValue());
                this.hideTasks.remove(player.getUniqueId());
            }
            int taskId = Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> {
                if (this.bossBars.containsKey(player.getUniqueId())) {
                    this.remove(player);
                }
                this.hideTasks.remove(player.getUniqueId());
            }, (long)this.timeout * 20L);
            this.hideTasks.put(player.getUniqueId(), taskId);
        }
    }
}

