/*
 * Decompiled with CFR 0.152.
 */
package gg.bundlegroup.scenes.worldguard.worldguard;

import com.sk89q.worldguard.WorldGuard;
import com.sk89q.worldguard.protection.flags.Flag;
import com.sk89q.worldguard.protection.flags.SetFlag;
import com.sk89q.worldguard.protection.flags.StringFlag;
import com.sk89q.worldguard.session.SessionManager;
import com.sk89q.worldguard.session.handler.Handler;
import gg.bundlegroup.scenes.Addon;
import gg.bundlegroup.scenes.api.Controller;
import gg.bundlegroup.scenes.api.Scenes;
import gg.bundlegroup.scenes.worldguard.worldguard.SceneRegionHandler;
import gg.bundlegroup.scenes.worldguard.worldguard.UnionSetFlag;
import java.util.Objects;
import org.bukkit.plugin.Plugin;
import org.jspecify.annotations.Nullable;

public class WorldGuardAddon
implements Addon {
    private final Plugin plugin;
    private final Scenes scenes;
    private @Nullable SetFlag<String> flag;
    private @Nullable Controller controller;

    public WorldGuardAddon(Plugin plugin, Scenes scenes) {
        this.plugin = plugin;
        this.scenes = scenes;
    }

    @Override
    public void load() {
        this.flag = new UnionSetFlag<String>("scenes", (Flag<String>)new StringFlag(null));
        WorldGuard.getInstance().getFlagRegistry().register(this.flag);
    }

    @Override
    public void enable() {
        Objects.requireNonNull(this.flag);
        this.controller = this.scenes.createController(this.plugin);
        SessionManager sessionManager = WorldGuard.getInstance().getPlatform().getSessionManager();
        sessionManager.registerHandler((Handler.Factory)new SceneRegionHandler.Factory(this.controller, this.flag), null);
    }

    @Override
    public void disable() {
        if (this.controller != null) {
            this.controller.close();
            this.controller = null;
        }
    }
}

