/*
 * Decompiled with CFR 0.152.
 */
package gg.bundlegroup.scenes.worldguard.worldguard;

import com.google.common.collect.Sets;
import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldedit.entity.Player;
import com.sk89q.worldedit.util.Location;
import com.sk89q.worldguard.LocalPlayer;
import com.sk89q.worldguard.protection.ApplicableRegionSet;
import com.sk89q.worldguard.protection.flags.Flag;
import com.sk89q.worldguard.protection.flags.SetFlag;
import com.sk89q.worldguard.session.MoveType;
import com.sk89q.worldguard.session.Session;
import com.sk89q.worldguard.session.handler.FlagValueChangeHandler;
import com.sk89q.worldguard.session.handler.Handler;
import gg.bundlegroup.scenes.api.Controller;
import java.util.Set;
import org.jspecify.annotations.Nullable;

public class SceneRegionHandler
extends FlagValueChangeHandler<Set<String>> {
    private final Controller controller;

    public SceneRegionHandler(Session session, Controller controller, Flag<Set<String>> flag) {
        super(session, flag);
        this.controller = controller;
    }

    protected void onInitialValue(LocalPlayer player, ApplicableRegionSet set, @Nullable Set<String> value) {
        org.bukkit.entity.Player bukkitPlayer = BukkitAdapter.adapt((Player)player);
        if (value != null) {
            for (String name : value) {
                this.controller.showTag(bukkitPlayer, name);
            }
        }
    }

    protected boolean onSetValue(LocalPlayer player, Location from, Location to, ApplicableRegionSet toSet, Set<String> currentValue, @Nullable Set<String> lastValue, MoveType moveType) {
        if (lastValue == null) {
            return true;
        }
        org.bukkit.entity.Player bukkitPlayer = BukkitAdapter.adapt((Player)player);
        for (String name : Sets.difference(lastValue, currentValue)) {
            this.controller.hideTag(bukkitPlayer, name);
        }
        for (String name : Sets.difference(currentValue, lastValue)) {
            this.controller.showTag(bukkitPlayer, name);
        }
        return true;
    }

    protected boolean onAbsentValue(LocalPlayer player, Location from, Location to, ApplicableRegionSet toSet, Set<String> lastValue, MoveType moveType) {
        org.bukkit.entity.Player bukkitPlayer = BukkitAdapter.adapt((Player)player);
        for (String name : lastValue) {
            this.controller.hideTag(bukkitPlayer, name);
        }
        return true;
    }

    public static class Factory
    extends Handler.Factory<SceneRegionHandler> {
        private final Controller controller;
        private final SetFlag<String> flag;

        public Factory(Controller controller, SetFlag<String> flag) {
            this.controller = controller;
            this.flag = flag;
        }

        public SceneRegionHandler create(Session session) {
            return new SceneRegionHandler(session, this.controller, (Flag<Set<String>>)this.flag);
        }
    }
}

