/*
 * Decompiled with CFR 0.152.
 */
package gg.bundlegroup.scenes.traincarts.action;

import com.bergerkiller.bukkit.tc.controller.MinecartMember;
import com.bergerkiller.bukkit.tc.events.SignActionEvent;
import com.bergerkiller.bukkit.tc.properties.api.IStringSetProperty;
import gg.bundlegroup.scenes.traincarts.action.ClearSceneAction;
import gg.bundlegroup.scenes.traincarts.action.HideSceneAction;
import gg.bundlegroup.scenes.traincarts.action.InvalidSceneAction;
import gg.bundlegroup.scenes.traincarts.action.SetSceneAction;
import gg.bundlegroup.scenes.traincarts.action.ShowSceneAction;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.jspecify.annotations.Nullable;

public interface SceneAction {
    public static SceneAction parse(SignActionEvent info) {
        String action;
        return switch (action = SceneAction.parseAction(info)) {
            case "show" -> new ShowSceneAction(SceneAction.parseScenes(info));
            case "hide" -> new HideSceneAction(SceneAction.parseScenes(info));
            case "set" -> new SetSceneAction(SceneAction.parseScenes(info));
            case "clear" -> new ClearSceneAction();
            default -> new InvalidSceneAction();
        };
    }

    private static String parseAction(SignActionEvent info) {
        String line = info.getLine(1);
        int index = line.indexOf(32);
        if (index == -1) {
            return "";
        }
        return line.substring(index + 1).trim();
    }

    private static Set<String> parseScenes(SignActionEvent info) {
        HashSet<String> scenes = new HashSet<String>();
        scenes.add(info.getLine(2));
        scenes.add(info.getLine(3));
        scenes.addAll(Arrays.asList(info.getExtraLinesBelow()));
        scenes.remove("");
        return scenes;
    }

    public void execute(MinecartMember<?> var1, IStringSetProperty var2);

    public @Nullable String getDescription();
}

